/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.mixin_interfaces.ILimited;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.Utils;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.station.AbstractStationScreen;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationScreen;
import com.simibubi.create.content.trains.station.TrainEditPacket;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StationScreen.class}, remap=false)
public abstract class MixinStationScreen
extends AbstractStationScreen {
    @Shadow
    private EditBox trainNameBox;
    private Checkbox limitEnableCheckbox;
    private List<ResourceLocation> iconTypes;
    private ScrollInput iconTypeScroll;

    private MixinStationScreen(StationBlockEntity te, GlobalStation station) {
        super(te, station);
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/station/StationScreen;tickTrainDisplay()V")}, remap=true)
    private void initCheckbox(CallbackInfo ci) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.limitEnableCheckbox = new Checkbox(x + this.background.width - 98, y + this.background.height - 26, 50, 20, (Component)Components.translatable((String)"railways.station.train_limit"), this.station != null && ((ILimited)this.station).isLimitEnabled(), true){

            public void m_5691_() {
                super.m_5691_();
                CRPackets.PACKETS.send((SimplePacketBase)ILimited.makeLimitEnabledPacket(MixinStationScreen.this.blockEntity.m_58899_(), this.m_93840_()));
            }

            public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
                if (this.m_198029_()) {
                    guiGraphics.m_280666_(MixinStationScreen.this.f_96547_, (List)ImmutableList.of((Object)Components.translatable((String)"railways.station.train_limit.tooltip.1"), (Object)Components.translatable((String)"railways.station.train_limit.tooltip.2")), mouseX, mouseY);
                }
            }
        };
        this.m_142416_((GuiEventListener)this.limitEnableCheckbox);
        this.iconTypes = TrainIconType.REGISTRY.keySet().stream().toList();
        this.iconTypeScroll = new ScrollInput(x + 4, y + 17, 184, 14).titled(Lang.translateDirect((String)"station.icon_type", (Object[])new Object[0]));
        this.iconTypeScroll.withRange(0, this.iconTypes.size());
        this.iconTypeScroll.withStepFunction(ctx -> -((Integer)this.iconTypeScroll.standardStep().apply(ctx)).intValue());
        this.iconTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.icon = TrainIconType.byId((ResourceLocation)this.iconTypes.get((int)s));
                Utils.sendCreatePacketToServer((SimplePacketBase)new TrainEditPacket(train.id, this.trainNameBox.m_94155_(), train.icon.getId()));
            }
        });
        this.iconTypeScroll.f_93623_ = false;
    }

    @Inject(method={"tickTrainDisplay"}, at={@At(value="HEAD")})
    private void tickIconScroll(CallbackInfo ci) {
        Train train = (Train)this.displayedTrain.get();
        if (train == null) {
            Train imminentTrain;
            if (this.iconTypeScroll.f_93623_) {
                this.iconTypeScroll.f_93623_ = false;
                this.m_169411_((GuiEventListener)this.iconTypeScroll);
            }
            if ((imminentTrain = this.getImminent()) != null) {
                this.iconTypeScroll.f_93623_ = true;
                this.iconTypeScroll.setState(this.iconTypes.indexOf(imminentTrain.icon.getId()));
                this.m_142416_((GuiEventListener)this.iconTypeScroll);
            }
        }
    }
}

