/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class BackupData
extends SavedData {
    private long lastSaved;
    private long lastFullBackup;
    private boolean paused;
    private boolean merging;
    private boolean usesTickCounter;

    private BackupData() {
    }

    public static BackupData get(ServerLevel level) {
        return BackupData.get(level.m_7654_());
    }

    public static BackupData get(MinecraftServer server) {
        return (BackupData)server.m_129783_().m_8895_().m_164861_(nbt -> new BackupData().load((CompoundTag)nbt), BackupData::new, "simplebackups");
    }

    public BackupData load(@Nonnull CompoundTag nbt) {
        this.lastSaved = nbt.m_128454_("lastSaved");
        this.lastFullBackup = nbt.m_128454_("lastFullBackup");
        this.paused = nbt.m_128471_("paused");
        this.merging = nbt.m_128471_("merging");
        this.usesTickCounter = nbt.m_128471_("usesTickCounter");
        return this;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        nbt.m_128356_("lastSaved", this.lastSaved);
        nbt.m_128356_("lastFullBackup", this.lastFullBackup);
        nbt.m_128379_("paused", this.paused);
        nbt.m_128379_("merging", this.merging);
        nbt.m_128379_("usesTickCounter", this.usesTickCounter);
        return nbt;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
        this.m_77762_();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getLastSaved() {
        return this.lastSaved;
    }

    public void updateSaveTime(long time) {
        this.lastSaved = time;
        this.m_77762_();
    }

    public long getLastFullBackup() {
        return this.lastFullBackup;
    }

    public void updateFullBackupTime(long time) {
        this.lastFullBackup = time;
        this.m_77762_();
    }

    public boolean isMerging() {
        return this.merging;
    }

    public void startMerging() {
        this.merging = true;
    }

    public void stopMerging() {
        this.merging = false;
    }

    public boolean usesTickCounter() {
        return this.usesTickCounter;
    }

    public void setUsesTickCounter(boolean usesTickCounter) {
        this.usesTickCounter = usesTickCounter;
        this.m_77762_();
    }
}

