/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic.requirement;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.TierSortingRegistry;
import se.mickelus.mutil.util.JsonOptional;
import se.mickelus.tetra.util.TierHelper;

public class IntegerPredicate
implements Predicate<Integer> {
    Integer min;
    Integer max;

    public IntegerPredicate(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean test(Integer value) {
        if (this.min != null && this.min > value) {
            return false;
        }
        return this.max == null || this.max >= value;
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        if (this.min != null) {
            json.addProperty("min", (Number)this.min);
        }
        if (this.max != null) {
            json.addProperty("max", (Number)this.max);
        }
        return json;
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        if (this.min != Integer.MIN_VALUE) {
            buffer.writeInt(this.min.intValue());
        }
        if (this.max != Integer.MIN_VALUE) {
            buffer.writeInt(this.max.intValue());
        }
    }

    @Nullable
    public static IntegerPredicate fromBuffer(FriendlyByteBuf buffer) {
        int tierMin = buffer.m_130242_();
        int tierMax = buffer.m_130242_();
        return tierMin != Integer.MIN_VALUE || tierMax != Integer.MIN_VALUE ? new IntegerPredicate(tierMin != Integer.MIN_VALUE ? Integer.valueOf(tierMin) : null, tierMax != Integer.MIN_VALUE ? Integer.valueOf(tierMax) : null) : null;
    }

    public static class Deserializer
    implements JsonDeserializer<IntegerPredicate> {
        private static int getLevel(JsonElement element) {
            if (element.getAsJsonPrimitive().isNumber()) {
                return element.getAsInt();
            }
            return Optional.ofNullable(TierSortingRegistry.byName((ResourceLocation)new ResourceLocation(element.getAsString()))).map(TierHelper::getIndex).map(index -> index + 1).orElse(0);
        }

        public IntegerPredicate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Deserializer.deserialize(json);
        }

        public static IntegerPredicate deserialize(JsonElement json) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                return new IntegerPredicate(JsonOptional.field((JsonObject)jsonObject, (String)"min").map(Deserializer::getLevel).orElse(null), JsonOptional.field((JsonObject)jsonObject, (String)"max").map(Deserializer::getLevel).orElse(null));
            }
            int value = json.getAsInt();
            return new IntegerPredicate(value, value);
        }
    }
}

