/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.gauge;

import com.simibubi.create.AllPackets;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.gauge.GaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.GaugeObservedPacket;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StressGaugeBlockEntity
extends GaugeBlockEntity {
    public AbstractComputerBehaviour computerBehaviour;
    static BlockPos lastSent;

    public StressGaugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        this.registerAwardables(behaviours, AllAdvancements.STRESSOMETER, AllAdvancements.STRESSOMETER_MAXED);
    }

    @Override
    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.dialTarget = !IRotate.StressImpact.isEnabled() ? 0.0f : (this.isOverStressed() ? 1.125f : (maxStress == 0.0f ? 0.0f : currentStress / maxStress));
        if (this.dialTarget > 0.0f) {
            this.color = this.dialTarget < 0.5f ? Color.mixColors(65280, 0xFFFF00, this.dialTarget * 2.0f) : (this.dialTarget < 1.0f ? Color.mixColors(0xFFFF00, 0xFF0000, this.dialTarget * 2.0f - 1.0f) : 0xFF0000);
        }
        this.sendData();
        this.m_6596_();
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getSpeed() == 0.0f) {
            this.dialTarget = 0.0f;
            this.m_6596_();
            return;
        }
        this.updateFromNetwork(this.capacity, this.stress, this.getOrCreateNetwork().getSize());
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return false;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        double capacity = this.getNetworkCapacity();
        double stressFraction = (double)this.getNetworkStress() / (capacity == 0.0 ? 1.0 : capacity);
        Lang.translate("gui.stressometer.title", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (this.getTheoreticalSpeed() == 0.0f) {
            Lang.text(TooltipHelper.makeProgressBar(3, 0)).translate("gui.stressometer.no_rotation", new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
        } else {
            IRotate.StressImpact.getFormattedStressText(stressFraction).forGoggles(tooltip);
            Lang.translate("gui.stressometer.capacity", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            double remainingCapacity = capacity - (double)this.getNetworkStress();
            LangBuilder su = Lang.translate("generic.unit.stress", new Object[0]);
            LangBuilder stressTip = Lang.number(remainingCapacity).add(su).style(IRotate.StressImpact.of(stressFraction).getRelativeColor());
            if (remainingCapacity != capacity) {
                stressTip.text(ChatFormatting.GRAY, " / ").add(Lang.number(capacity).add(su).style(ChatFormatting.DARK_GRAY));
            }
            stressTip.forGoggles(tooltip, 1);
        }
        if (!this.f_58858_.equals((Object)lastSent)) {
            lastSent = this.f_58858_;
            AllPackets.getChannel().sendToServer((Object)new GaugeObservedPacket(lastSent));
        }
        return true;
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket && this.f_58858_ != null && this.f_58858_.equals((Object)lastSent)) {
            lastSent = null;
        }
    }

    public float getNetworkStress() {
        return this.stress;
    }

    public float getNetworkCapacity() {
        return this.capacity;
    }

    public void onObserved() {
        this.award(AllAdvancements.STRESSOMETER);
        if (Mth.m_14033_((float)this.dialTarget, (float)1.0f)) {
            this.award(AllAdvancements.STRESSOMETER_MAXED);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.computerBehaviour.removePeripheral();
    }
}

