/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.transfer;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.foundation.utility.Pair;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class GenericItemEmptying {
    private static final RecipeWrapper WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public static boolean canItemBeEmptied(Level world, ItemStack stack) {
        if (PotionFluidHandler.isPotionItem(stack)) {
            return true;
        }
        WRAPPER.m_6836_(0, stack);
        if (AllRecipeTypes.EMPTYING.find(WRAPPER, world).isPresent()) {
            return true;
        }
        LazyOptional capability = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return false;
        }
        for (int i = 0; i < tank.getTanks(); ++i) {
            if (tank.getFluidInTank(i).getAmount() <= 0) continue;
            return true;
        }
        return false;
    }

    public static Pair<FluidStack, ItemStack> emptyItem(Level world, ItemStack stack, boolean simulate) {
        FluidStack resultingFluid = FluidStack.EMPTY;
        ItemStack resultingItem = ItemStack.f_41583_;
        if (PotionFluidHandler.isPotionItem(stack)) {
            return PotionFluidHandler.emptyPotion(stack, simulate);
        }
        WRAPPER.m_6836_(0, stack);
        Optional recipe = AllRecipeTypes.EMPTYING.find(WRAPPER, world);
        if (recipe.isPresent()) {
            EmptyingRecipe emptyingRecipe = (EmptyingRecipe)recipe.get();
            List<ItemStack> results = emptyingRecipe.rollResults();
            if (!simulate) {
                stack.m_41774_(1);
            }
            resultingItem = results.isEmpty() ? ItemStack.f_41583_ : results.get(0);
            resultingFluid = emptyingRecipe.getResultingFluid();
            return Pair.of(resultingFluid, resultingItem);
        }
        ItemStack split = stack.m_41777_();
        split.m_41764_(1);
        LazyOptional capability = split.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return Pair.of(resultingFluid, resultingItem);
        }
        resultingFluid = tank.drain(1000, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        resultingItem = tank.getContainer().m_41777_();
        if (!simulate) {
            stack.m_41774_(1);
        }
        return Pair.of(resultingFluid, resultingItem);
    }
}

