/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.simibubi.create.AllPackets;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.foundation.networking.ISyncPersistentData;
import com.simibubi.create.foundation.utility.WorldAttached;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class ToolboxHandler {
    public static final WorldAttached<WeakHashMap<BlockPos, ToolboxBlockEntity>> toolboxes = new WorldAttached<WeakHashMap>(w -> new WeakHashMap());
    static int validationTimer = 20;

    public static void onLoad(ToolboxBlockEntity be) {
        toolboxes.get((LevelAccessor)be.m_58904_()).put(be.m_58899_(), be);
    }

    public static void onUnload(ToolboxBlockEntity be) {
        toolboxes.get((LevelAccessor)be.m_58904_()).remove(be.m_58899_());
    }

    public static void entityTick(Entity entity, Level world) {
        if (world.f_46443_) {
            return;
        }
        if (!(world instanceof ServerLevel)) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        if (entity.f_19797_ % validationTimer != 0) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!player.getPersistentData().m_128441_("CreateToolboxData")) {
            return;
        }
        boolean sendData = false;
        CompoundTag compound = player.getPersistentData().m_128469_("CreateToolboxData");
        for (int i = 0; i < 9; ++i) {
            String key = String.valueOf(i);
            if (!compound.m_128441_(key)) continue;
            CompoundTag data = compound.m_128469_(key);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("Pos"));
            int slot = data.m_128451_("Slot");
            if (!world.m_46749_(pos)) continue;
            if (!(world.m_8055_(pos).m_60734_() instanceof ToolboxBlock)) {
                compound.m_128473_(key);
                sendData = true;
                continue;
            }
            BlockEntity prevBlockEntity = world.m_7702_(pos);
            if (!(prevBlockEntity instanceof ToolboxBlockEntity)) continue;
            ((ToolboxBlockEntity)prevBlockEntity).connectPlayer(slot, (Player)player, i);
        }
        if (sendData) {
            ToolboxHandler.syncData((Player)player);
        }
    }

    public static void playerLogin(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        if (player.getPersistentData().m_128441_("CreateToolboxData") && !player.getPersistentData().m_128469_("CreateToolboxData").m_128456_()) {
            ToolboxHandler.syncData(player);
        }
    }

    public static void syncData(Player player) {
        AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ISyncPersistentData.PersistentDataPacket((Entity)player));
    }

    public static List<ToolboxBlockEntity> getNearest(LevelAccessor world, Player player, int maxAmount) {
        Vec3 location = player.m_20182_();
        double maxRange = ToolboxHandler.getMaxRange(player);
        return toolboxes.get(world).keySet().stream().filter(p -> ToolboxHandler.distance(location, p) < maxRange * maxRange).sorted((p1, p2) -> Double.compare(ToolboxHandler.distance(location, p1), ToolboxHandler.distance(location, p2))).limit(maxAmount).map(toolboxes.get(world)::get).filter(ToolboxBlockEntity::isFullyInitialized).collect(Collectors.toList());
    }

    public static void unequip(Player player, int hotbarSlot, boolean keepItems) {
        CompoundTag compound = player.getPersistentData().m_128469_("CreateToolboxData");
        Level world = player.m_9236_();
        String key = String.valueOf(hotbarSlot);
        if (!compound.m_128441_(key)) {
            return;
        }
        CompoundTag prevData = compound.m_128469_(key);
        BlockPos prevPos = NbtUtils.m_129239_((CompoundTag)prevData.m_128469_("Pos"));
        int prevSlot = prevData.m_128451_("Slot");
        BlockEntity prevBlockEntity = world.m_7702_(prevPos);
        if (prevBlockEntity instanceof ToolboxBlockEntity) {
            ToolboxBlockEntity toolbox = (ToolboxBlockEntity)prevBlockEntity;
            toolbox.unequip(prevSlot, player, hotbarSlot, keepItems || !ToolboxHandler.withinRange(player, toolbox));
        }
        compound.m_128473_(key);
    }

    public static boolean withinRange(Player player, ToolboxBlockEntity box) {
        if (player.m_9236_() != box.m_58904_()) {
            return false;
        }
        double maxRange = ToolboxHandler.getMaxRange(player);
        return ToolboxHandler.distance(player.m_20182_(), box.m_58899_()) < maxRange * maxRange;
    }

    public static double distance(Vec3 location, BlockPos p) {
        return location.m_82531_((double)((float)p.m_123341_() + 0.5f), (double)p.m_123342_(), (double)((float)p.m_123343_() + 0.5f));
    }

    public static double getMaxRange(Player player) {
        return ((Integer)AllConfigs.server().equipment.toolboxRange.get()).doubleValue();
    }
}

