/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.world.NCPlacedFeatures;
import igentuman.nc.world.ore.NCOre;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class NCBiomeModifier {
    public static final HashMap<String, ResourceKey<BiomeModifier>> BIOME_MODIFIERS = NCBiomeModifier.initBiomeModifiers();

    private static HashMap<String, ResourceKey<BiomeModifier>> initBiomeModifiers() {
        HashMap<String, ResourceKey<BiomeModifier>> map = new HashMap<String, ResourceKey<BiomeModifier>>();
        for (String name : Ores.all().keySet()) {
            map.put(name, NCBiomeModifier.registerKey(name + "_biome_modifier"));
        }
        map.put("glowing_mushroom", NCBiomeModifier.registerKey("glowing_mushroom_biome_modifier"));
        return map;
    }

    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        for (String name : Ores.registered().keySet()) {
            NCOre ore = Ores.all().get(name);
            if (ore.config().dimensions.contains(0)) {
                context.m_255272_(BIOME_MODIFIERS.get(name), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES.get(name))}), GenerationStep.Decoration.UNDERGROUND_ORES));
            }
            if (ore.config().dimensions.contains(-1)) {
                context.m_255272_(BIOME_MODIFIERS.get(name), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_207612_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES.get(name))}), GenerationStep.Decoration.UNDERGROUND_ORES));
            }
            if (!ore.config().dimensions.contains(1)) continue;
            context.m_255272_(BIOME_MODIFIERS.get(name), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_215818_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES.get(name))}), GenerationStep.Decoration.UNDERGROUND_ORES));
        }
        context.m_255272_(BIOME_MODIFIERS.get("glowing_mushroom"), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_207612_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES.get("glowing_mushroom"))}), GenerationStep.Decoration.UNDERGROUND_DECORATION));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NuclearCraft.rl(name));
    }
}

