/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.io.IOUtils;

public class DataGenUtil {
    private static final Pattern MTLLIB = Pattern.compile("^mtllib\\s+(.*)$", 8);
    private static final Pattern USEMTL = Pattern.compile("^usemtl\\s+(.*)$", 8);
    private static final Pattern NEWMTL = Pattern.compile("^newmtl\\s+(.*)$", 8);
    private static final Pattern MAP_KD = Pattern.compile("^map_Kd\\s+(.*)$", 8);

    public static String getTextureFromObj(ResourceLocation obj, ExistingFileHelper helper) {
        try {
            String prefix = "models";
            if (obj.m_135815_().startsWith("models/")) {
                prefix = "";
            }
            Resource objResource = helper.getResource(obj, PackType.CLIENT_RESOURCES, "", prefix);
            InputStream objStream = objResource.m_215507_();
            String fullObj = IOUtils.toString((InputStream)objStream, (Charset)StandardCharsets.US_ASCII);
            String libLoc = DataGenUtil.findFirstOccurrenceGroup(MTLLIB, fullObj);
            String libName = DataGenUtil.findFirstOccurrenceGroup(USEMTL, fullObj);
            ResourceLocation libRL = DataGenUtil.relative(obj, libLoc);
            return DataGenUtil.getMTLTexture(libRL, libName, helper);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMTLTexture(ResourceLocation mtl, String materialName, ExistingFileHelper helper) {
        try {
            Resource mtlResource = helper.getResource(mtl, PackType.CLIENT_RESOURCES, "", "models");
            String fullMtl = IOUtils.toString((InputStream)mtlResource.m_215507_(), (Charset)StandardCharsets.US_ASCII);
            Matcher materialMatcher = NEWMTL.matcher(fullMtl);
            while (materialMatcher.find() && !materialMatcher.group(1).equals(materialName)) {
            }
            int materialStart = materialMatcher.start();
            int materialEnd = materialMatcher.find() ? materialMatcher.start() : fullMtl.length();
            String material = fullMtl.substring(materialStart, materialEnd);
            return DataGenUtil.findFirstOccurrenceGroup(MAP_KD, material);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String findFirstOccurrenceGroup(Pattern pattern, String input) {
        Matcher matcher = pattern.matcher(input);
        Preconditions.checkArgument((boolean)matcher.find());
        return matcher.group(1);
    }

    private static ResourceLocation relative(ResourceLocation base, String relativePath) {
        String basePath = base.m_135815_();
        String lastDir = basePath.substring(0, basePath.lastIndexOf(47) + 1);
        return new ResourceLocation(base.m_135827_(), lastDir + relativePath);
    }
}

