/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import igentuman.nc.block.ElectromagnetBlock;
import igentuman.nc.block.ElectromagnetSlopeBlock;
import igentuman.nc.block.GlowingMushroomBlock;
import igentuman.nc.block.PortalBlock;
import igentuman.nc.block.RFAmplifierBlock;
import igentuman.nc.block.RedstoneDimmerBlock;
import igentuman.nc.block.entity.RedstoneDimmerBE;
import igentuman.nc.container.RedstoneDImmerContainer;
import igentuman.nc.content.Electromagnets;
import igentuman.nc.content.RFAmplifier;
import igentuman.nc.content.materials.Blocks;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.setup.registration.Tags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class NCBlocks {
    public static final BlockBehaviour.Properties ORE_BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60978_(2.0f).m_60999_();
    public static final Item.Properties BLOCK_ITEM_PROPERTIES = new Item.Properties();
    public static final BlockBehaviour.Properties NC_BLOCKS_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(2.0f).m_60999_();
    public static final BlockBehaviour.Properties ORE_DEEPSLATE_BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60978_(4.0f).m_60999_();
    public static HashMap<String, RegistryObject<Block>> ORE_BLOCKS = new HashMap();
    public static HashMap<String, RegistryObject<Block>> NC_BLOCKS = new HashMap();
    public static HashMap<String, RegistryObject<Block>> NC_RF_AMPLIFIERS = new HashMap();
    public static HashMap<String, RegistryObject<Block>> NC_ELECTROMAGNETS = new HashMap();
    public static HashMap<String, RegistryObject<Block>> MULTI_BLOCKS = new HashMap();
    public static HashMap<String, RegistryObject<Block>> NC_MATERIAL_BLOCKS = new HashMap();
    public static final Item.Properties ORE_ITEM_PROPERTIES = new Item.Properties();
    public static final Item.Properties MULTIBLOCK_ITEM_PROPERTIES = new Item.Properties();
    public static final RegistryObject<Block> PORTAL_BLOCK = Registries.BLOCKS.register("portal", PortalBlock::new);
    public static final RegistryObject<Block> REDSTONE_DIMMER_BLOCK = Registries.BLOCKS.register("redstone_dimmer", RedstoneDimmerBlock::new);
    public static final RegistryObject<Item> REDSTONE_DIMMER_ITEM_BLOCK = NCBlocks.fromBlock(REDSTONE_DIMMER_BLOCK);
    public static final RegistryObject<BlockEntityType<RedstoneDimmerBE>> REDSTONE_DIMMER_BE = Registries.BLOCK_ENTITIES.register("redstone_dimmer", () -> BlockEntityType.Builder.m_155273_(RedstoneDimmerBE::new, (Block[])new Block[]{(Block)REDSTONE_DIMMER_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<Block> MUSHROOM_BLOCK = Registries.BLOCKS.register("glowing_mushroom", () -> new GlowingMushroomBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56740_).m_60910_().m_60966_().m_60977_().m_60953_($ -> 10)));
    public static final RegistryObject<MenuType<RedstoneDImmerContainer>> REDSTONE_DIMMER_CONTAINER = Registries.CONTAINERS.register("redstone_dimmer", () -> IForgeMenuType.create((windowId, inv, data) -> new RedstoneDImmerContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<Item> MUSHROOM_ITEM = NCBlocks.fromBlock(MUSHROOM_BLOCK);
    public static final RegistryObject<Item> PORTAL_ITEM = NCBlocks.fromBlock(PORTAL_BLOCK);
    public static TagKey<Block> DECAY_GEN_BLOCK = Tags.blockTag("decay_gen_block");

    public static void init() {
        NCBlocks.registerOres();
        NCBlocks.registerBlocks();
        NCBlocks.registerMagnets();
        NCBlocks.registerAmplifiers();
    }

    private static void registerOres() {
        for (String name : Ores.all().keySet()) {
            Tags.ORE_TAGS.put(name, (TagKey<Block>)TagKey.m_203882_(Registries.BLOCK_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "ores/" + name)));
            Tags.addOreTag(name);
            if (Materials.ores().get((Object)name).normal_ore) {
                ORE_BLOCKS.put(name, (RegistryObject<Block>)Registries.BLOCKS.register(name + "_ore", () -> new Block(ORE_BLOCK_PROPERTIES)));
                NCItems.ORE_BLOCK_ITEMS.put(name, NCBlocks.fromOreBlock(ORE_BLOCKS.get(name)));
                NCItems.ALL_NC_ITEMS.put("ore_" + name, NCItems.ORE_BLOCK_ITEMS.get(name));
            }
            if (Materials.ores().get((Object)name).deepslate_ore) {
                ORE_BLOCKS.put(name + "_deepslate", (RegistryObject<Block>)Registries.BLOCKS.register(name + "_deepslate_ore", () -> new Block(ORE_DEEPSLATE_BLOCK_PROPERTIES)));
                NCItems.ORE_BLOCK_ITEMS.put(name + "_deepslate", NCBlocks.fromOreBlock(ORE_BLOCKS.get(name + "_deepslate")));
                NCItems.ALL_NC_ITEMS.put("ore_" + name + "_deepslate", NCItems.ORE_BLOCK_ITEMS.get(name + "_deepslate"));
            }
            if (Materials.ores().get((Object)name).nether_ore) {
                ORE_BLOCKS.put(name + "_nether", (RegistryObject<Block>)Registries.BLOCKS.register(name + "_nether_ore", () -> new Block(ORE_BLOCK_PROPERTIES)));
                NCItems.ORE_BLOCK_ITEMS.put(name + "_nether", NCBlocks.fromOreBlock(ORE_BLOCKS.get(name + "_nether")));
                NCItems.ALL_NC_ITEMS.put("ore_" + name + "_nether", NCItems.ORE_BLOCK_ITEMS.get(name + "_nether"));
            }
            if (!Materials.ores().get((Object)name).end_ore) continue;
            ORE_BLOCKS.put(name + "_end", (RegistryObject<Block>)Registries.BLOCKS.register(name + "_end_ore", () -> new Block(ORE_BLOCK_PROPERTIES)));
            NCItems.ORE_BLOCK_ITEMS.put(name + "_end", NCBlocks.fromOreBlock(ORE_BLOCKS.get(name + "_end")));
            NCItems.ALL_NC_ITEMS.put("ore_" + name + "_end", NCItems.ORE_BLOCK_ITEMS.get(name + "_end"));
        }
    }

    private static void registerMagnets() {
        for (String name : Electromagnets.all().keySet()) {
            NC_ELECTROMAGNETS.put(name, (RegistryObject<Block>)Registries.BLOCKS.register(name, () -> new ElectromagnetBlock(NC_BLOCKS_PROPERTIES)));
            NC_ELECTROMAGNETS.put(name + "_slope", (RegistryObject<Block>)Registries.BLOCKS.register(name + "_slope", () -> new ElectromagnetSlopeBlock(NC_BLOCKS_PROPERTIES)));
            NCItems.NC_ELECTROMAGNETS_ITEMS.put(name, NCBlocks.fromBlock(NC_ELECTROMAGNETS.get(name)));
            NCItems.NC_ELECTROMAGNETS_ITEMS.put(name + "_slope", NCBlocks.fromBlock(NC_ELECTROMAGNETS.get(name + "_slope")));
            NCItems.ALL_NC_ITEMS.put(name, NCItems.NC_ELECTROMAGNETS_ITEMS.get(name));
            NCItems.ALL_NC_ITEMS.put(name + "_slope", NCItems.NC_ELECTROMAGNETS_ITEMS.get(name + "_slope"));
        }
    }

    private static void registerAmplifiers() {
        for (String name : RFAmplifier.all().keySet()) {
            NC_RF_AMPLIFIERS.put(name, (RegistryObject<Block>)Registries.BLOCKS.register(name, () -> new RFAmplifierBlock(NC_BLOCKS_PROPERTIES)));
            NCItems.NC_RF_AMPLIFIERS_ITEMS.put(name, NCBlocks.fromBlock(NC_RF_AMPLIFIERS.get(name)));
            NCItems.ALL_NC_ITEMS.put(name, NCItems.NC_RF_AMPLIFIERS_ITEMS.get(name));
        }
    }

    private static void registerBlocks() {
        for (String name : Blocks.get().all().keySet()) {
            Tags.BLOCK_TAGS.put(name, (TagKey<Block>)TagKey.m_203882_(Registries.BLOCK_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "storage_blocks/" + name)));
            Tags.BLOCK_ITEM_TAGS.put(name, (TagKey<Item>)TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)new ResourceLocation("forge", "storage_blocks/" + name)));
            NC_MATERIAL_BLOCKS.put(name, (RegistryObject<Block>)Registries.BLOCKS.register(name + "_block", () -> new Block(NC_BLOCKS_PROPERTIES)));
            NCItems.NC_BLOCKS_ITEMS.put(name, NCBlocks.fromBlock(NC_MATERIAL_BLOCKS.get(name)));
            NCItems.ALL_NC_ITEMS.put(name + "_block", NCItems.NC_BLOCKS_ITEMS.get(name));
        }
        NCItems.ALL_NC_ITEMS.put("glowing_mushroom", NCItems.NC_BLOCKS_ITEMS.get("glowing_mushroom"));
    }

    public static <B extends Block> RegistryObject<Item> fromOreBlock(RegistryObject<B> block) {
        return Registries.ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), ORE_ITEM_PROPERTIES));
    }

    public static <B extends Block> RegistryObject<Item> fromBlock(RegistryObject<B> block) {
        return Registries.ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), BLOCK_ITEM_PROPERTIES));
    }

    public static <B extends Block> RegistryObject<Item> fromMultiblock(RegistryObject<B> block) {
        return Registries.ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), MULTIBLOCK_ITEM_PROPERTIES));
    }

    public static final class BlockEntry<T extends Block>
    implements Supplier<T>,
    ItemLike {
        public static final Collection<BlockEntry<?>> ALL_ENTRIES = new ArrayList();
        private final RegistryObject<T> regObject;
        private final Supplier<BlockBehaviour.Properties> properties;

        public static BlockEntry<FenceBlock> fence(String name, Supplier<BlockBehaviour.Properties> props) {
            return new BlockEntry<FenceBlock>(name, props, FenceBlock::new);
        }

        public BlockEntry(String name, Supplier<BlockBehaviour.Properties> properties, Function<BlockBehaviour.Properties, T> make) {
            this.properties = properties;
            this.regObject = Registries.BLOCKS.register(name, () -> (Block)make.apply((BlockBehaviour.Properties)properties.get()));
            ALL_ENTRIES.add(this);
        }

        public BlockEntry(T existing) {
            this.properties = () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)existing);
            this.regObject = RegistryObject.create((ResourceLocation)ForgeRegistries.BLOCKS.getKey(existing), (IForgeRegistry)ForgeRegistries.BLOCKS);
        }

        public BlockEntry(BlockEntry<? extends T> toCopy) {
            this.properties = toCopy.properties;
            this.regObject = toCopy.regObject;
        }

        @Override
        public T get() {
            return (T)((Block)this.regObject.get());
        }

        public BlockState defaultBlockState() {
            return this.get().m_49966_();
        }

        public ResourceLocation getId() {
            return this.regObject.getId();
        }

        public BlockBehaviour.Properties getProperties() {
            return this.properties.get();
        }

        @Nonnull
        public Item m_5456_() {
            return this.get().m_5456_();
        }
    }
}

