/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.serializers;

import com.google.gson.JsonObject;
import igentuman.nc.NuclearCraft;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.serializers.NcRecipeSerializer;
import igentuman.nc.recipes.type.NcRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class CoolantRecipeSerializer<RECIPE extends NcRecipe>
extends NcRecipeSerializer<RECIPE> {
    public CoolantRecipeSerializer(NcRecipeSerializer.IFactory factory) {
        super(factory);
    }

    @Override
    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        FluidStackIngredient[] inputFluids = this.inputFluidsFromJson(json, recipeId);
        FluidStackIngredient[] outputFluids = this.outputFluidsFromJson(json, recipeId);
        double coolingRate = 1000.0;
        try {
            coolingRate = GsonHelper.m_144742_((JsonObject)json, (String)"coolingRate", (double)1000.0);
        }
        catch (Exception ex) {
            NuclearCraft.LOGGER.warn("Unable to parse params for recipe: " + recipeId);
        }
        return this.factory.create(recipeId, new ItemStackIngredient[0], new ItemStackIngredient[0], inputFluids, outputFluids, 1.0, 1.0, 1.0, coolingRate);
    }

    @Override
    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient[] inputItems = this.readItems(buffer);
            ItemStackIngredient[] outputItems = this.readItems(buffer);
            FluidStackIngredient[] inputFluids = this.readFluids(buffer);
            FluidStackIngredient[] outputFluids = this.readFluids(buffer);
            double coolingRate = buffer.readDouble();
            double powerModifier = buffer.readDouble();
            double radiation = buffer.readDouble();
            return this.factory.create(recipeId, new ItemStackIngredient[0], new ItemStackIngredient[0], inputFluids, outputFluids, coolingRate, 1.0, 1.0, 1.0);
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("Error reading from packet.", (Throwable)e);
            throw e;
        }
    }
}

