/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.ingredient.creator;

import igentuman.nc.NuclearCraft;
import igentuman.nc.recipes.ingredient.creator.IFluidStackIngredientCreator;
import igentuman.nc.recipes.ingredient.creator.IIngredientCreator;
import igentuman.nc.recipes.ingredient.creator.IItemStackIngredientCreator;
import java.util.function.Consumer;

public class IngredientCreatorAccess {
    private static IItemStackIngredientCreator ITEM_STACK_INGREDIENT_CREATOR;
    private static IFluidStackIngredientCreator FLUID_STACK_INGREDIENT_CREATOR;

    private IngredientCreatorAccess() {
    }

    public static IItemStackIngredientCreator item() {
        if (ITEM_STACK_INGREDIENT_CREATOR == null) {
            IngredientCreatorAccess.lookupInstance(IItemStackIngredientCreator.class, "igentuman.nc.recipes.ingredient.creator.ItemStackIngredientCreator", helper -> {
                ITEM_STACK_INGREDIENT_CREATOR = helper;
            });
        }
        return ITEM_STACK_INGREDIENT_CREATOR;
    }

    public static IFluidStackIngredientCreator fluid() {
        if (FLUID_STACK_INGREDIENT_CREATOR == null) {
            IngredientCreatorAccess.lookupInstance(IFluidStackIngredientCreator.class, "igentuman.nc.recipes.ingredient.creator.FluidStackIngredientCreator", helper -> {
                FLUID_STACK_INGREDIENT_CREATOR = helper;
            });
        }
        return FLUID_STACK_INGREDIENT_CREATOR;
    }

    private static <TYPE extends IIngredientCreator<?, ?, ?>> void lookupInstance(Class<TYPE> type, String className, Consumer<TYPE> setter) {
        try {
            Class<?> clazz = Class.forName(className);
            setter.accept((IIngredientCreator)type.cast(clazz.getField("INSTANCE").get(null)));
        }
        catch (ReflectiveOperationException ex) {
            NuclearCraft.LOGGER.error("Error retrieving {}, Nuclearcraft may be absent, damaged, or outdated.", (Object)className);
        }
    }
}

