/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.event.server;

import igentuman.nc.block.turbine.TurbineBladeBlock;
import igentuman.nc.item.HEVItem;
import igentuman.nc.item.HazmatItem;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.radiation.data.RadiationEvents;
import igentuman.nc.setup.registration.NCItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nuclearcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldEvents {
    public static List<Block> trackingBlocks = new ArrayList<Block>();

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockState state = event.getState();
        if (state == null) {
            return;
        }
        if (trackingBlocks.contains(state.m_60734_())) {
            MultiblockHandler.trackBlockChange(event.getPos());
        }
        if (state == null || state.m_60795_() || state.m_155947_()) {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        boolean placed = true;
        BlockState state = event.getState();
        if (state == null) {
            return;
        }
        if (trackingBlocks.contains(state.m_60734_())) {
            MultiblockHandler.trackBlockChange(event.getPos());
        }
        if (state.m_60734_() instanceof TurbineBladeBlock) {
            placed = TurbineBladeBlock.processBlockPlace(event.getLevel(), event.getPos(), event.getPlacedBlock(), state, event.getPlacedAgainst());
        }
        if (!placed) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void chunkUnloadEvent(ChunkEvent.Unload event) {
    }

    @SubscribeEvent
    public void worldUnloadEvent(LevelEvent.Unload event) {
    }

    @SubscribeEvent
    public void worldLoadEvent(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            MultiblockHandler.tick();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.LevelTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            RadiationEvents.onWorldTick(event);
        }
    }

    public static int getHEVProtectionRate(Player player) {
        int rate = 0;
        for (ItemStack stack : player.m_6168_()) {
            if (!(stack.m_41720_() instanceof HEVItem) || !WorldEvents.isCharged(stack)) continue;
            ++rate;
        }
        return rate;
    }

    public static boolean isFullyEquipped(Player player) {
        for (ItemStack stack : player.m_6168_()) {
            if (stack.m_41720_() instanceof HazmatItem || stack.m_41720_() instanceof HEVItem) continue;
            return false;
        }
        return true;
    }

    public static boolean isCharged(ItemStack item) {
        return item.getCapability(ForgeCapabilities.ENERGY).map(handler -> handler.getEnergyStored() > 0).orElse(false);
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            int protectionRate;
            Player player = (Player)livingEntity;
            if (event.getSource() != null && event.getSource().m_276093_(DamageTypes.f_268515_) && WorldEvents.isFullyEquipped(player)) {
                event.setAmount(event.getAmount() / 10.0f);
            }
            if (event.getSource() != null && event.getSource().m_276093_(DamageTypes.f_268671_)) {
                player.m_6168_().forEach(stack -> {
                    if (stack.m_41720_().equals(NCItems.HEV_BOOTS.get()) && WorldEvents.isCharged(stack)) {
                        WorldEvents.consumeEnergy(stack, 1000);
                        event.setCanceled(true);
                        return;
                    }
                });
            }
            if ((protectionRate = WorldEvents.getHEVProtectionRate(player)) > 0) {
                event.setAmount(event.getAmount() - event.getAmount() * ((float)protectionRate * 0.1f));
                for (ItemStack stack2 : player.m_6168_()) {
                    WorldEvents.consumeEnergy(stack2, 1000);
                }
            }
        }
    }

    private static void consumeEnergy(ItemStack stack, int i) {
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> handler.extractEnergy(i, false));
    }
}

