/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.fluid;

import igentuman.nc.block.NCFluidBlock;
import igentuman.nc.setup.registration.NCFluids;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class NCFluid
extends FlowingFluid {
    private static NCFluids.FluidEntry entryStatic;
    protected final NCFluids.FluidEntry entry;

    public static NCFluid makeFluid(Function<NCFluids.FluidEntry, ? extends NCFluid> make, NCFluids.FluidEntry entry) {
        entryStatic = entry;
        NCFluid result = make.apply(entry);
        entryStatic = null;
        return result;
    }

    public Vec3 m_7000_(BlockGetter pBlockReader, BlockPos pPos, FluidState pFluidState) {
        if (this.getFluidType().getDensity() < 0) {
            return new Vec3(0.0, 0.1, 0.0);
        }
        return super.m_7000_(pBlockReader, pPos, pFluidState);
    }

    public NCFluid(NCFluids.FluidEntry entry) {
        this.entry = entry;
    }

    @Nonnull
    public Item m_6859_() {
        return this.entry.getBucket();
    }

    protected boolean m_5486_(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluidIn, Direction direction) {
        return direction == Direction.DOWN && !this.m_6212_(fluidIn);
    }

    public boolean m_6212_(@Nonnull Fluid fluidIn) {
        return fluidIn == this.entry.getStill() || fluidIn == this.entry.getFlowing();
    }

    public int m_6718_(LevelReader p_205569_1_) {
        if (this.getFluidType().getDensity() == -1000) {
            return 0;
        }
        int dW = this.m_5615_().getFluidType().getViscosity() - Fluids.f_76193_.getFluidType().getViscosity();
        double v = Math.round(5.0 + (double)dW * 0.005);
        return Math.max(2, (int)v);
    }

    protected float m_6752_() {
        return 100.0f;
    }

    protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.m_7180_(builder);
        for (Property<?> p : (this.entry == null ? entryStatic : this.entry).properties()) {
            builder.m_61104_(new Property[]{p});
        }
    }

    protected BlockState m_5804_(FluidState state) {
        BlockState result = (BlockState)this.entry.getBlock().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(NCFluid.m_76092_((FluidState)state)));
        for (Property<?> prop : this.entry.properties()) {
            result = NCFluidBlock.withCopiedValue(prop, result, state);
        }
        return result;
    }

    public boolean m_7444_(FluidState state) {
        return state.m_76152_() == this.entry.getStill();
    }

    public int m_7430_(FluidState state) {
        if (this.m_7444_(state)) {
            return 8;
        }
        return (Integer)state.m_61143_((Property)f_75948_);
    }

    public FluidType getFluidType() {
        return (FluidType)this.entry.type().get();
    }

    @Nonnull
    public Fluid m_5615_() {
        return this.entry.getFlowing();
    }

    @Nonnull
    public Fluid m_5613_() {
        return this.entry.getStill();
    }

    protected boolean m_6760_(Level level) {
        return false;
    }

    protected void m_7456_(LevelAccessor iWorld, BlockPos blockPos, BlockState blockState) {
    }

    protected int m_6719_(LevelReader iWorldReader) {
        return 4;
    }

    protected int m_6713_(LevelReader iWorldReader) {
        return 1;
    }

    public static Consumer<FluidType.Properties> createBuilder(int density, int viscosity) {
        return builder -> builder.viscosity(viscosity).density(density);
    }

    public static class Flowing
    extends NCFluid {
        public String name;

        public Flowing(NCFluids.FluidEntry entry) {
            super(entry);
        }

        @Override
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }

        protected void m_76010_(Level pLevel, BlockPos pPos, FluidState pState) {
            if (this.entry.getFlowing().getFluidType().getDensity() > -1000) {
                super.m_76010_(pLevel, pPos, pState);
                return;
            }
            BlockState blockstate = pLevel.m_8055_(pPos);
            BlockPos blockpos = pPos.m_7494_();
            BlockState blockstate1 = pLevel.m_8055_(blockpos);
            FluidState fluidstate = this.m_76035_(pLevel, blockpos.m_7495_(), blockstate1);
            if (this.m_75977_((BlockGetter)pLevel, pPos, blockstate, Direction.UP, blockpos, blockstate1, pLevel.m_6425_(blockpos), fluidstate.m_76152_())) {
                this.m_6364_((LevelAccessor)pLevel, blockpos, blockstate1, Direction.UP, fluidstate);
            }
        }
    }
}

