/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.block.entity.fusion.FusionCoreBE;
import igentuman.nc.block.entity.turbine.TurbineControllerBE;
import igentuman.nc.client.NcClient;
import igentuman.nc.client.gui.fission.FissionControllerScreen;
import igentuman.nc.client.gui.processor.NCProcessorScreen;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.jei.FissionBoilingCategoryWrapper;
import igentuman.nc.compat.jei.FissionCategoryWrapper;
import igentuman.nc.compat.jei.FusionCategoryWrapper;
import igentuman.nc.compat.jei.FusionCoolantCategoryWrapper;
import igentuman.nc.compat.jei.MekChemicalConversionCategoryWrapper;
import igentuman.nc.compat.jei.OreVeinCategoryWrapper;
import igentuman.nc.compat.jei.ProcessorCategoryWrapper;
import igentuman.nc.compat.jei.TurbineControllerCategoryWrapper;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.type.MekChemicalConversionRecipe;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.recipes.type.OreVeinRecipe;
import igentuman.nc.util.ModUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static HashMap<String, RecipeType<? extends NcRecipe>> recipeTypes;
    public static final RecipeType<FissionControllerBE.Recipe> FISSION;
    public static final RecipeType<FusionCoreBE.Recipe> FUSION;
    public static final RecipeType<FusionCoreBE.FusionCoolantRecipe> FUSION_COOLANT;
    public static final RecipeType<FissionControllerBE.FissionBoilingRecipe> FISSION_BOILING;
    public static final RecipeType<TurbineControllerBE.Recipe> TURBINE_CONTROLLER;
    public static final RecipeType<MekChemicalConversionRecipe> CHEMICAL_TO_FLUID;
    public static final RecipeType<OreVeinRecipe> ORE_VEINS;

    private static HashMap<String, RecipeType<? extends NcRecipe>> getRecipeTypes() {
        if (recipeTypes == null) {
            recipeTypes = new HashMap();
            for (String name : GlobalVars.RECIPE_CLASSES.keySet()) {
                if (Processors.all().containsKey(name) && !Processors.all().get(name).isRegistered()) continue;
                recipeTypes.put(name, (RecipeType<? extends NcRecipe>)new RecipeType(new ResourceLocation("nuclearcraft", name), GlobalVars.RECIPE_CLASSES.get(name)));
            }
        }
        return recipeTypes;
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("nuclearcraft", "jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeManager = jeiRuntime.getRecipeManager();
        for (String name : Processors.all().keySet()) {
            ResourceLocation categoryToHide;
            if (Processors.registered().containsKey(name) || !recipeManager.getRecipeType(categoryToHide = NuclearCraft.rl(name)).isPresent()) continue;
            recipeManager.hideRecipeCategory((RecipeType)recipeManager.getRecipeType(categoryToHide).get());
        }
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        for (String name : JEIPlugin.getRecipeTypes().keySet()) {
            if (!Processors.all().containsKey(name)) continue;
            registration.addRecipeCategories(new IRecipeCategory[]{new ProcessorCategoryWrapper(registration.getJeiHelpers().getGuiHelper(), this.getRecipeType(name))});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new OreVeinCategoryWrapper<OreVeinRecipe>(registration.getJeiHelpers().getGuiHelper(), ORE_VEINS)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FusionCategoryWrapper<FusionCoreBE.Recipe>(registration.getJeiHelpers().getGuiHelper(), FUSION)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FusionCoolantCategoryWrapper<FusionCoreBE.FusionCoolantRecipe>(registration.getJeiHelpers().getGuiHelper(), FUSION_COOLANT)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FissionBoilingCategoryWrapper<FissionControllerBE.FissionBoilingRecipe>(registration.getJeiHelpers().getGuiHelper(), FISSION_BOILING)});
        registration.addRecipeCategories(new IRecipeCategory[]{new TurbineControllerCategoryWrapper<TurbineControllerBE.Recipe>(registration.getJeiHelpers().getGuiHelper(), TURBINE_CONTROLLER)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FissionCategoryWrapper<FissionControllerBE.Recipe>(registration.getJeiHelpers().getGuiHelper(), FISSION)});
        if (ModUtil.isMekanismLoadeed()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new MekChemicalConversionCategoryWrapper<MekChemicalConversionRecipe>(registration.getJeiHelpers().getGuiHelper(), CHEMICAL_TO_FLUID)});
        }
    }

    public <TYPE> RecipeType<TYPE> getRecipeType(String name) {
        return recipeTypes.get(name);
    }

    public <TYPE> RecipeType<TYPE> getRecipeType(RecipeType<? extends AbstractRecipe> in) {
        return in;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        try {
            for (String name : JEIPlugin.getRecipeTypes().keySet()) {
                if (List.of("fusion_core", "fusion_coolant", "fission_reactor_controller", "fission_boiling", "nc_ore_veins", "turbine_controller").contains(name)) continue;
                registration.addRecipes(this.getRecipeType(name), NcRecipeType.ALL_RECIPES.get(name).getRecipes(NcClient.tryGetClientWorld()));
            }
            registration.addRecipes(this.getRecipeType(FUSION), NcRecipeType.ALL_RECIPES.get("fusion_core").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(FUSION_COOLANT), NcRecipeType.ALL_RECIPES.get("fusion_coolant").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(FISSION), NcRecipeType.ALL_RECIPES.get(FissionControllerBE.NAME).getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(FISSION_BOILING), NcRecipeType.ALL_RECIPES.get("fission_boiling").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(TURBINE_CONTROLLER), NcRecipeType.ALL_RECIPES.get(TurbineControllerBE.NAME).getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(ORE_VEINS), NcRecipeType.ALL_RECIPES.get("nc_ore_veins").getRecipes(NcClient.tryGetClientWorld()));
            if (ModUtil.isMekanismLoadeed()) {
                registration.addRecipes(this.getRecipeType(CHEMICAL_TO_FLUID), MekChemicalConversionRecipe.getRecipes());
            }
        }
        catch (IllegalArgumentException ex) {
            NuclearCraft.LOGGER.error("Error registering recipes for JEI: " + ex.getMessage());
        }
    }

    private <T extends AbstractContainerScreen<?>> void addRecipeClickArea(IGuiHandlerRegistration registration, Class<? extends T> containerScreenClass, final int xPos, final int yPos, final int width, final int height, RecipeType<?> ... recipeTypes) {
        if (recipeTypes == null) {
            return;
        }
        registration.addGuiContainerHandler(containerScreenClass, new IGuiContainerHandler<T>(){

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull T containerScreen, double mouseX, double mouseY) {
                NCProcessorScreen screen = (NCProcessorScreen)containerScreen;
                String name = screen.getRecipeTypeName();
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)xPos, (int)yPos, (int)width, (int)height, (RecipeType[])new RecipeType[]{JEIPlugin.getRecipeTypes().get(name)});
                return List.of(clickableArea);
            }
        });
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        for (String name : JEIPlugin.getRecipeTypes().keySet()) {
            if (!Processors.registered().containsKey(name)) continue;
            this.addRecipeClickArea(registration, NCProcessorScreen.class, 67, 74, 18, 18, this.getRecipeType(name));
        }
        registration.addRecipeClickArea(FissionControllerScreen.class, 69, 42, 36, 26, new RecipeType[]{FISSION});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        for (String name : JEIPlugin.getRecipeTypes().keySet()) {
            if (!GlobalVars.CATALYSTS.containsKey(name)) continue;
            for (ItemStack stack : GlobalVars.CATALYSTS.get(name)) {
                registry.addRecipeCatalyst(stack, new RecipeType[]{this.getRecipeType(name)});
            }
        }
        if (GlobalVars.CATALYSTS.containsKey(FissionControllerBE.NAME)) {
            registry.addRecipeCatalyst(GlobalVars.CATALYSTS.get(FissionControllerBE.NAME).get(0), new RecipeType[]{FISSION});
        }
        if (GlobalVars.CATALYSTS.containsKey("nc_ore_veins")) {
            registry.addRecipeCatalyst(GlobalVars.CATALYSTS.get("nc_ore_veins").get(0), new RecipeType[]{ORE_VEINS});
        }
    }

    static {
        FISSION = new RecipeType(new ResourceLocation("nuclearcraft", FissionControllerBE.NAME), FissionControllerBE.Recipe.class);
        FUSION = new RecipeType(new ResourceLocation("nuclearcraft", "fusion_core"), FusionCoreBE.Recipe.class);
        FUSION_COOLANT = new RecipeType(new ResourceLocation("nuclearcraft", "fusion_coolant"), FusionCoreBE.FusionCoolantRecipe.class);
        FISSION_BOILING = new RecipeType(new ResourceLocation("nuclearcraft", "fission_boiling"), FissionControllerBE.FissionBoilingRecipe.class);
        TURBINE_CONTROLLER = new RecipeType(new ResourceLocation("nuclearcraft", TurbineControllerBE.NAME), TurbineControllerBE.Recipe.class);
        CHEMICAL_TO_FLUID = new RecipeType(new ResourceLocation("nuclearcraft", "mek_chemical_to_fluid"), MekChemicalConversionRecipe.class);
        ORE_VEINS = new RecipeType(new ResourceLocation("nuclearcraft", "nc_ore_veins"), OreVeinRecipe.class);
    }
}

