/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.gt;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import igentuman.nc.handler.config.ProcessorsConfig;
import igentuman.nc.util.CustomEnergyStorage;
import net.minecraft.core.Direction;

public class NCGTEnergyHandler
implements IEnergyContainer {
    private final CustomEnergyStorage energyStorage;
    private final long voltage;
    private final long amperage;
    private boolean overloaded = false;

    public NCGTEnergyHandler(CustomEnergyStorage energyStorage, long voltage, long amperage) {
        this.energyStorage = energyStorage;
        this.voltage = voltage;
        this.amperage = amperage;
    }

    public boolean isOverloaded() {
        return this.overloaded;
    }

    public long acceptEnergyFromNetwork(Direction direction, long voltage, long amperage) {
        if (amperage >= this.getInputAmperage() && (Integer)ProcessorsConfig.PROCESSOR_CONFIG.GT_SUPPORT.get() == 2) {
            return 0L;
        }
        long canAccept = this.getEnergyCapacity() - this.getEnergyStored();
        boolean bl = this.overloaded = voltage > this.getInputVoltage() || this.overloaded;
        if (canAccept >= voltage) {
            long amperesAccepted = Math.min(canAccept / voltage, Math.min(amperage, this.getInputAmperage()));
            this.addEnergy(voltage * amperesAccepted);
            return amperesAccepted;
        }
        return 0L;
    }

    public long addEnergy(long energyToAdd) {
        long wasEnergy = this.energyStorage.getEnergyStored();
        this.energyStorage.addEnergy((int)(energyToAdd * 4L));
        return ((long)this.energyStorage.getEnergyStored() - wasEnergy) / 4L;
    }

    public boolean inputsEnergy(Direction direction) {
        return true;
    }

    public long changeEnergy(long energyToAdd) {
        long result = this.addEnergy(energyToAdd);
        if (this.energyStorage.getEnergyStored() < 0) {
            this.energyStorage.setEnergy(0);
        }
        return result;
    }

    public long getEnergyStored() {
        return this.energyStorage.getEnergyStored() / 4;
    }

    public long getEnergyCapacity() {
        return this.energyStorage.getMaxEnergyStored() / 4;
    }

    public long getInputAmperage() {
        return this.amperage;
    }

    public long getInputVoltage() {
        return this.voltage;
    }
}

