/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.block;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import igentuman.nc.client.block.BatteryBlockBakedModel;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public class BatteryBlockLoader
implements IGeometryLoader<BatteryModelGeometry> {
    public static final ResourceLocation BATTERY_LOADER = new ResourceLocation("nuclearcraft", "battery_loader");

    public BatteryModelGeometry read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
        String side = jsonObject.get("textures").getAsJsonObject().get("down").getAsString();
        String up = jsonObject.get("textures").getAsJsonObject().get("up").getAsString();
        Material sideDefault = ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(side));
        Material sideIn = ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(side + "_in"));
        Material sideOut = ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(side + "_out"));
        Material sideNone = ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(side + "_non"));
        Material topDefault = ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(up));
        Material topIn = ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(up + "_in"));
        Material topOut = ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(up + "_out"));
        Material topNone = ForgeHooksClient.getBlockMaterial((ResourceLocation)new ResourceLocation(up + "_non"));
        return new BatteryModelGeometry(sideDefault, sideIn, sideOut, sideNone, topDefault, topIn, topOut, topNone);
    }

    public static class BatteryModelGeometry
    implements IUnbakedGeometry<BatteryModelGeometry> {
        public final Material sideDefault;
        public final Material sideIn;
        public final Material sideOut;
        public final Material sideNone;
        public final Material topDefault;
        public final Material topIn;
        public final Material topOut;
        public final Material topNone;

        public BatteryModelGeometry(Material side, Material sideIn, Material sideOut, Material sideNone, Material top, Material topIn, Material topOut, Material topNone) {
            this.sideDefault = side;
            this.topDefault = top;
            this.sideIn = sideIn;
            this.sideOut = sideOut;
            this.sideNone = sideNone;
            this.topIn = topIn;
            this.topOut = topOut;
            this.topNone = topNone;
        }

        public BakedModel bake(IGeometryBakingContext iGeometryBakingContext, ModelBaker modelBaker, Function<Material, TextureAtlasSprite> function, ModelState modelState, ItemOverrides itemOverrides, ResourceLocation resourceLocation) {
            return new BatteryBlockBakedModel(modelState, function, itemOverrides, iGeometryBakingContext.getTransforms(), this);
        }
    }
}

