/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.turbine;

import igentuman.nc.block.entity.turbine.TurbineBE;
import igentuman.nc.block.entity.turbine.TurbineCoilBE;
import igentuman.nc.handler.event.client.InputEvents;
import igentuman.nc.multiblock.turbine.CoilDef;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurbineCoilBlock
extends Block
implements EntityBlock {
    public double efficiency = 0.0;
    public String type = "";
    public CoilDef def;
    public Component placementRule;

    public TurbineCoilBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_));
    }

    public TurbineCoilBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56743_));
    }

    private void initParams() {
        Item item = Item.m_41439_((Block)this);
        if (item.toString().isEmpty()) {
            return;
        }
        this.type = item.toString().replaceAll("_coil|turbine_", "");
        this.def = TurbineRegistration.coils.get(this.type);
        this.efficiency = this.def.getEfficiency();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (this.def == null) {
            this.initParams();
        }
        this.def.getValidator();
        TurbineCoilBE be = (TurbineCoilBE)((BlockEntityType)TurbineRegistration.TURBINE_BE.get("turbine_coil").get()).m_155264_(pPos, pState);
        be.setCoilDef(this.def);
        return be;
    }

    private List<String> getBlockNames(String rawLine) {
        String[] blocks;
        ArrayList<String> names = new ArrayList<String>();
        String[] conditionParts = rawLine.split("=|-|>|<|\\^");
        for (String code : blocks = conditionParts[0].split("\\|")) {
            Object id = code;
            if (!((String)id).contains(":")) {
                id = "nuclearcraft:" + (String)id;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)id));
                names.add(block.m_49954_().getString());
                continue;
            }
            names.add(TextUtils.convertToName(((String)id).split(":")[1]));
        }
        return names;
    }

    public Component getPlacementRule() {
        if (this.placementRule == null) {
            ArrayList<String> lines = new ArrayList<String>();
            int i = 0;
            if (this.def.getValidator() instanceof CoilDef.Validator) {
                for (String[] condition : this.def.getValidator().blockLines().keySet()) {
                    if (i > 0) {
                        lines.add(Component.m_237115_((String)"heat_sink.and").getString());
                    }
                    String blocksLine = String.join((CharSequence)(" " + Component.m_237115_((String)"heat_sink.or").getString() + " "), this.getBlockNames(condition[2]));
                    switch (condition[0]) {
                        case ">": {
                            lines.add(Component.m_237110_((String)("heat_sink.atleast" + (condition[1].equals("1") ? "" : "s")), (Object[])new Object[]{condition[1], blocksLine}).getString());
                            break;
                        }
                        case "-": {
                            lines.add(Component.m_237110_((String)"heat_sink.between", (Object[])new Object[]{condition[1], blocksLine}).getString());
                            break;
                        }
                        case "=": {
                            lines.add(Component.m_237110_((String)("heat_sink.exact" + (condition[1].equals("1") ? "" : "s")), (Object[])new Object[]{condition[1], blocksLine}).getString());
                            break;
                        }
                        case "<": {
                            lines.add(Component.m_237110_((String)"heat_sink.less_than", (Object[])new Object[]{condition[1], blocksLine}).getString());
                            break;
                        }
                        case "^": {
                            lines.add(Component.m_237110_((String)"heat_sink.in_corner", (Object[])new Object[]{condition[1], blocksLine}).getString());
                        }
                    }
                    ++i;
                }
                this.placementRule = Component.m_237110_((String)"heat_sink.placement.rule", (Object[])new Object[]{String.join((CharSequence)" ", lines)});
            } else {
                this.placementRule = Component.m_237115_((String)"heat_sink.placement.error");
            }
        }
        return this.placementRule;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof TurbineCoilBE) {
                    TurbineCoilBE tile = (TurbineCoilBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof TurbineCoilBE) {
                TurbineCoilBE tile = (TurbineCoilBE)t;
                tile.tickServer();
            }
        };
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        ((TurbineBE)Objects.requireNonNull(level.m_7702_(pos))).onNeighborChange(state, pos, neighbor);
    }

    public void m_5871_(ItemStack pStack, @javax.annotation.Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        this.initParams();
        if (InputEvents.DESCRIPTIONS_SHOW) {
            list.add((Component)TextUtils.applyFormat(this.getPlacementRule(), ChatFormatting.AQUA));
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)"tooltip.nc.description.efficiency", (Object[])new Object[]{TextUtils.numberFormat(this.def.getEfficiency())}), ChatFormatting.GOLD));
        } else {
            list.add((Component)TextUtils.applyFormat((Component)Component.m_237115_((String)"tooltip.toggle_description_keys"), ChatFormatting.GRAY));
        }
    }
}

