/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.processor;

import igentuman.nc.block.entity.fission.FissionBE;
import igentuman.nc.block.entity.fission.FissionControllerBE;
import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.multiblock.AbstractNCMultiblock;
import igentuman.nc.multiblock.IMultiblockAttachable;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.annotation.NothingNullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class IrradiatorBE
extends NCProcessorBE<Recipe>
implements IMultiblockAttachable {
    private AbstractNCMultiblock multiblock;
    private FissionControllerBE<?> controller;
    @NBTField
    public int irradiativeFlux = 0;
    @NBTField
    public double fuelMultiplier = 1.0;

    public IrradiatorBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, Processors.IRRADIATOR);
    }

    @Override
    public String getName() {
        return Processors.IRRADIATOR;
    }

    @Override
    public double speedMultiplier() {
        return (double)this.irradiativeFlux / 10.0 * this.fuelMultiplier;
    }

    @Override
    public void setMultiblock(AbstractNCMultiblock multiblock) {
        this.multiblock = multiblock;
    }

    @Override
    public FissionControllerBE<?> controller() {
        return this.controller;
    }

    @Override
    public AbstractNCMultiblock multiblock() {
        return this.multiblock;
    }

    @Override
    public boolean canInvalidateCache() {
        return true;
    }

    @Override
    public void tickServer() {
        int wasFlux = this.irradiativeFlux;
        double wasFuel = this.fuelMultiplier;
        this.irradiativeFlux = 0;
        this.fuelMultiplier = 0.0;
        this.upadteMultiblockConnection();
        if (this.multiblock != null && this.multiblock.isFormed() && this.multiblock.controller() != null) {
            this.controller = (FissionControllerBE)this.multiblock.controller().controllerBE();
            if (this.controller.isProcessing()) {
                this.irradiativeFlux = this.controller.irradiationConnections;
                this.fuelMultiplier = ((FissionControllerBE.Recipe)this.controller.recipeInfo.recipe()).getRadiation() * 10000.0;
            }
        }
        if (this.speedMultiplier() > 0.0) {
            super.tickServer();
        }
        if (wasFlux != this.irradiativeFlux || wasFuel != this.fuelMultiplier) {
            this.m_6596_();
        }
    }

    @Override
    protected void processRecipe() {
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (!this.hasRecipe()) {
            this.isActive = false;
            return;
        }
        if (this.energyStorage.getEnergyStored() < this.energyPerTick() * this.skippedTicks) {
            this.isActive = false;
            return;
        }
        boolean processed = this.recipeInfo.process(this.speedMultiplier() * (double)this.skippedTicks);
        if (processed) {
            this.controller().addIrradiationHeat();
        }
        if (this.recipeInfo.radiation != 1.0) {
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), this.recipeInfo.radiation / 1000000.0 * this.speedMultiplier() * (double)this.skippedTicks, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        }
        this.isActive = true;
        this.m_6596_();
        if (!this.recipeInfo.isCompleted() && this.hasRecipe()) {
            this.energyStorage.consumeEnergy(this.energyPerTick() * this.skippedTicks);
        }
    }

    public void upadteMultiblockConnection() {
        for (Direction d : Direction.values()) {
            if (d.equals((Object)this.getFacing()) || d.equals((Object)this.getFacing().m_122424_())) continue;
            BlockPos toCheck = this.m_58899_().m_121945_(d);
            BlockEntity be = this.m_58904_().m_7702_(toCheck);
            if (!(be instanceof FissionBE)) continue;
            this.multiblock = ((FissionBE)be).multiblock();
            this.controller = (FissionControllerBE)((FissionBE)be).controller();
        }
    }

    @NothingNullByDefault
    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, heatModifier, 1.0);
        }

        @Override
        public String getCodeId() {
            return Processors.IRRADIATOR;
        }
    }
}

