/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.fusion;

import dan200.computercraft.shared.Capabilities;
import igentuman.nc.block.entity.fusion.FusionBE;
import igentuman.nc.block.entity.fusion.FusionCoreBE;
import igentuman.nc.compat.oc2.NCFusionReactorDevice;
import igentuman.nc.multiblock.fusion.FusionReactor;
import igentuman.nc.util.ModUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class FusionCoreProxyBE
extends FusionBE {
    protected byte wasSignal = 0;

    public FusionCoreProxyBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FusionReactor.FUSION_CORE_PROXY_BE.get(), pPos, pBlockState);
    }

    protected void validateCore() {
        if (this.core != null) {
            if (!this.f_58857_.m_46749_(this.core.m_58899_())) {
                return;
            }
            this.core = (FusionCoreBE)this.f_58857_.m_7702_(this.core.m_58899_());
            this.corePos = this.core.m_58899_();
        } else {
            if (this.corePos == null) {
                return;
            }
            this.core = (FusionCoreBE)this.f_58857_.m_7702_(this.corePos);
        }
    }

    @Override
    public void tickServer() {
        if (this.m_58904_().m_46467_() % 20L == 0L) {
            this.validateCore();
        }
        if (!(this.core instanceof FusionCoreBE)) {
            this.f_58857_.m_7471_(this.f_58858_, false);
            return;
        }
        if (this.wasSignal != this.core.analogSignal) {
            this.wasSignal = this.core.analogSignal;
            this.m_6596_();
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    public void setCore(FusionCoreBE<?> core) {
        FusionCoreBE wasCore = this.core;
        this.core = core;
        this.corePos = core.m_58899_();
        if (wasCore != core) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void destroyCore() {
        if (this.corePos != null) {
            BlockState st = this.f_58857_.m_8055_(this.corePos);
            if (st.equals(Blocks.f_50016_.m_49966_())) {
                return;
            }
            ItemStack core = new ItemStack((ItemLike)st.m_60734_().m_5456_());
            this.f_58857_.m_7471_(this.corePos, false);
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.corePos, (ItemStack)core);
        }
    }

    public FusionCoreBE<?> getCoreBE() {
        return this.core;
    }

    public BlockPos getCorePos() {
        return this.corePos;
    }

    protected <T> LazyOptional<T> fluidHandler(@Nullable Direction side) {
        return this.controller().contentHandler.getFluidCapability(side);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.controller() == null) {
            return super.getCapability(cap, side);
        }
        if (side == null || side.m_122434_().m_122479_()) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler(side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.controller().getEnergy().cast();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.controller().getPeripheral(cap, side);
        }
        if (ModUtil.isOC2Loaded() && cap == NCFusionReactorDevice.DEVICE_CAPABILITY) {
            return this.controller().getOCDevice(cap, side);
        }
        if (ModUtil.isMekanismLoadeed()) {
            if (cap == mekanism.common.capabilities.Capabilities.GAS_HANDLER) {
                if (this.controller().contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.controller().contentHandler.gasConverter(side));
                }
                return LazyOptional.empty();
            }
            if (cap == mekanism.common.capabilities.Capabilities.SLURRY_HANDLER) {
                if (this.controller().contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.controller().contentHandler.getSlurryConverter(side));
                }
                return LazyOptional.empty();
            }
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    public void sendOutEnergy() {
        int required = this.getCoreBE().rfAmplifiersPower + this.getCoreBE().magnetsPower;
        for (Direction side : List.of(Direction.UP, Direction.DOWN)) {
            BlockEntity be;
            if (this.getCoreBE().energyStorage.getEnergyStored() <= required || !((be = this.m_58904_().m_7702_(this.m_58899_().m_121945_(side))) instanceof BlockEntity) || be instanceof FusionBE) continue;
            IEnergyStorage r = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, side.m_122424_()).orElse(null);
            if (r == null) break;
            if (!r.canReceive()) continue;
            int recieved = r.receiveEnergy(this.getCoreBE().energyStorage.getEnergyStored() - required, false);
            this.getCoreBE().energyStorage.setEnergy(this.getCoreBE().energyStorage.getEnergyStored() - recieved);
        }
    }

    public void forceTickServer(FusionCoreBE<?> core) {
        this.core = core;
        core.inputRedstoneSignal = Math.max(this.m_58904_().m_277086_(this.m_58899_()), core.inputRedstoneSignal);
        core.rfAmplificationRatio = (int)((double)core.inputRedstoneSignal / 0.15);
    }

    public void toggleRedstoneMode() {
        this.getCoreBE().toggleRedstoneMode();
    }

    public int getAnalogSignal() {
        return this.getCoreBE().analogSignal;
    }
}

