/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block;

import igentuman.nc.setup.registration.NCFluids;
import igentuman.nc.util.NCDamageSources;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class NCFluidBlock
extends LiquidBlock {
    private static NCFluids.FluidEntry entryStatic;
    private final NCFluids.FluidEntry entry;
    @Nullable
    private MobEffect effect;
    private int duration;
    private int level;

    public NCFluidBlock(NCFluids.FluidEntry entry, BlockBehaviour.Properties props) {
        super(entry.getStillGetter(), ((BlockBehaviour.Properties)Util.m_137469_((Object)props, $ -> {
            entryStatic = entry;
        })).m_60955_().m_60910_().m_222994_());
        this.entry = entry;
        entryStatic = null;
    }

    public boolean isFireSource(BlockState state, LevelReader level, BlockPos pos, Direction direction) {
        return this.getFluid().getFluidType().getTemperature() > 600;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.getFluid().getFluidType().getTemperature() > 600) {
            return 5;
        }
        return 0;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        for (Property<?> p : (this.entry == null ? entryStatic : this.entry).properties()) {
            builder.m_61104_(new Property[]{p});
        }
    }

    @Nonnull
    public FluidState m_5888_(@Nonnull BlockState state) {
        FluidState baseState = super.m_5888_(state);
        for (Property prop : baseState.m_61147_()) {
            if (!state.m_61138_(prop)) continue;
            baseState = NCFluidBlock.withCopiedValue(prop, baseState, state);
        }
        return baseState;
    }

    public static <T extends StateHolder<?, T>, S extends Comparable<S>> T withCopiedValue(Property<S> prop, T oldState, StateHolder<?, ?> copyFrom) {
        return (T)((StateHolder)oldState.m_61124_(prop, copyFrom.m_61143_(prop)));
    }

    public void setEffect(@Nonnull MobEffect effect, int duration, int level) {
        this.effect = effect;
        this.duration = duration;
        this.level = level;
    }

    public void m_7892_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (this.effect != null && entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(this.effect, this.duration, this.level));
        }
        if (this.getFluid().getFluidType().getTemperature() > 600) {
            entityIn.m_20254_(1);
        }
        if (this.getFluid().getFluidType().toString().contains("acid")) {
            entityIn.m_6469_(NCDamageSources.ACID, 1.0f);
        }
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (pLevel.m_6425_(pPos).getFluidType().getDensity() == -1000) {
            pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
        }
    }
}

