/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.emi;

import com.christofmeg.justenoughbreeding.emi.EMIPlugin;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.Utils;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreedingCategoryEMI
implements EmiRecipe {
    private final ResourceLocation id;
    private final BreedingRecipe recipe;
    public static final EmiTexture TOP = new EmiTexture(EmiRenderHelper.WIDGETS, 18, 0, 25, 1);
    public static final EmiTexture CORNER = new EmiTexture(EmiRenderHelper.WIDGETS, 43, 0, 1, 1);
    public static final EmiTexture LEFT = new EmiTexture(EmiRenderHelper.WIDGETS, 18, 0, 1, 25);
    public static final EmiTexture RIGHT = new EmiTexture(EmiRenderHelper.WIDGETS, 43, 1, 1, 25);
    public static final EmiTexture BOTTOM = new EmiTexture(EmiRenderHelper.WIDGETS, 19, 25, 25, 1);
    public static final EmiTexture BACKGROUND = new EmiTexture(EmiRenderHelper.WIDGETS, 19, 1, 24, 24);
    public static EmiRecipeCategory TYPE = new EmiRecipeCategory(new ResourceLocation("justenoughbreeding:breeding"), (EmiRenderable)EmiStack.of((ItemLike)Items.f_42405_), EMIPlugin.simplifiedRenderer(), EmiRecipeSorting.none());

    protected BreedingCategoryEMI(Builder builder, BreedingRecipe breedingRecipe) {
        this.id = builder.id;
        this.recipe = breedingRecipe;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EmiRecipeCategory getCategory() {
        return TYPE;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of((Ingredient)this.recipe.breedingCatalyst));
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(EmiIngredient.of((Ingredient)this.recipe.breedingCatalyst), EmiIngredient.of((Ingredient)this.recipe.extraInputStack), EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.recipe.spawnEgg})));
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> list = new ArrayList<EmiStack>();
        if (this.recipe.resultItemStack != null) {
            for (ItemStack item : this.recipe.resultItemStack.m_43908_()) {
                list.add(EmiStack.of((ItemStack)item));
            }
            list.add(EmiStack.of((ItemStack)this.recipe.spawnEgg));
        }
        return list;
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public int getDisplayWidth() {
        return 168;
    }

    public int getDisplayHeight() {
        return 93;
    }

    public void addWidgets(WidgetHolder widgets) {
        boolean hasOutput;
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)this.recipe.spawnEgg), 149, 1);
        int inputX = 74;
        int inputY = 48;
        int extraY = inputY - 19;
        boolean hasExtraInput = this.recipe.extraInputStack != null && !this.recipe.extraInputStack.m_43947_();
        boolean bl = hasOutput = this.recipe.resultItemStack != null && !this.recipe.resultItemStack.m_43947_();
        if (hasExtraInput && hasOutput) {
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.breedingCatalyst), inputX, inputY + 9);
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.extraInputStack), inputX, extraY + 9);
        } else if (hasExtraInput) {
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.breedingCatalyst), inputX + 33, inputY + 9);
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.extraInputStack), inputX + 33, extraY + 9);
        } else if (!hasOutput) {
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.breedingCatalyst), inputX + 33, inputY);
        } else {
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.breedingCatalyst), inputX, inputY);
        }
        if (hasOutput) {
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 98, 48);
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.resultItemStack), 130, 44).large(true).recipeContext((EmiRecipe)this);
        }
        widgets.addTexture(TOP, 1, 11);
        widgets.addTexture(TOP, 26, 11);
        widgets.addTexture(TOP, 36, 11);
        widgets.addTexture(CORNER, 61, 11);
        widgets.addTexture(LEFT, 1, 12);
        widgets.addTexture(LEFT, 1, 37);
        widgets.addTexture(LEFT, 1, 62);
        widgets.addTexture(LEFT, 1, 66);
        widgets.addTexture(RIGHT, 61, 12);
        widgets.addTexture(RIGHT, 61, 37);
        widgets.addTexture(RIGHT, 61, 62);
        widgets.addTexture(RIGHT, 61, 66);
        widgets.addTexture(BACKGROUND, 2, 12);
        widgets.addTexture(BACKGROUND, 26, 12);
        widgets.addTexture(BACKGROUND, 37, 12);
        widgets.addTexture(BACKGROUND, 2, 36);
        widgets.addTexture(BACKGROUND, 26, 36);
        widgets.addTexture(BACKGROUND, 37, 36);
        widgets.addTexture(BACKGROUND, 2, 60);
        widgets.addTexture(BACKGROUND, 26, 60);
        widgets.addTexture(BACKGROUND, 37, 60);
        widgets.addTexture(BACKGROUND, 2, 67);
        widgets.addTexture(BACKGROUND, 26, 67);
        widgets.addTexture(BACKGROUND, 37, 67);
        widgets.addTexture(CORNER, 1, 91);
        widgets.addTexture(BOTTOM, 2, 91);
        widgets.addTexture(BOTTOM, 27, 91);
        widgets.addTexture(BOTTOM, 37, 91);
        widgets.add(new Widget(){

            public Bounds getBounds() {
                return new Bounds(0, 0, 60, 80);
            }

            public void m_88315_(@NotNull GuiGraphics stack, int mouseX, int mouseY, float delta) {
                LivingEntity currentLivingEntity = BreedingCategoryEMI.this.recipe.doRendering();
                if (currentLivingEntity != null) {
                    Utils.renderEntity(stack.m_280168_(), mouseX, currentLivingEntity);
                }
            }
        });
        EntityType<?> entityType = this.recipe.entityType;
        if (entityType != null) {
            MutableComponent entityName = Component.m_237115_((String)entityType.m_20675_());
            Object entityNameString = entityName.getString();
            if (this.recipe.needsToBeTamed != null) {
                MutableComponent tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
            } else if (this.recipe.animalTrusting != null) {
                MutableComponent trusting = Component.m_237115_((String)"translation.justenoughbreeding.trusting");
                entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
            } else if (this.recipe.spawnEgg.m_41778_().startsWith("item.tfc")) {
                MutableComponent familiarity = Component.m_237115_((String)"tfc.jade.familiarity");
                String tfc = familiarity.getString().replaceAll(":[^:]*$", "");
                entityNameString = (String)entityNameString + " (" + tfc + " > 30)";
            }
            int stringWidth = Minecraft.m_91087_().f_91062_.m_92895_((String)entityNameString);
            int availableWidth = 154;
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)((String)entityNameString).length();
                int maxCharacters = (int)((float)availableWidth / pixelWidthPerCharacter);
                entityNameString = ((String)entityNameString).substring(0, maxCharacters);
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.m_130674_((String)entityNameString);
                widgets.addText(EmiPort.ordered((Component)abbreviatedEntityName), 1, 1, -1, true);
            }
        }
    }

    public static class Builder {
        private ResourceLocation id = null;
        private BreedingRecipe breedingRecipe;

        private Builder() {
        }

        public EmiRecipe build() {
            return new BreedingCategoryEMI(this, this.breedingRecipe);
        }

        public Builder id(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder breedingRecipe(BreedingRecipe recipe) {
            this.breedingRecipe = recipe;
            return this;
        }
    }
}

