/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Rectangle;
import java.util.Objects;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.mixin.MultiPlayerGameModeAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public enum BreakProgressProvider implements IEventListener
{
    INSTANCE;

    boolean wasBreaking = false;
    float progressDelayTimer = 0.0f;
    float lastProgress = 0.0f;
    float lastTargetProgress = 0.0f;

    @Override
    public void onAfterTooltipRender(GuiGraphics ctx, Rectangle rect, ICommonAccessor accessor, IPluginConfig config) {
        boolean isInDelay;
        if (!config.getBoolean(Options.BREAKING_PROGRESS)) {
            return;
        }
        MultiPlayerGameMode gameMode = Objects.requireNonNull(Minecraft.m_91087_().f_91072_);
        MultiPlayerGameModeAccess gameModeAccess = (MultiPlayerGameModeAccess)gameMode;
        float dt = Minecraft.m_91087_().m_91297_();
        boolean isBreaking = gameMode.m_105296_();
        float targetProgress = gameModeAccess.wthit_destroyProgress();
        if (!isBreaking && this.wasBreaking && this.progressDelayTimer <= 0.0f) {
            this.progressDelayTimer = 4.0f;
        }
        boolean bl = isInDelay = this.progressDelayTimer > 0.0f;
        if (isInDelay) {
            targetProgress = gameModeAccess.wthit_destroyDelay() > 0 ? 1.0f : this.lastTargetProgress;
        }
        float progressDiff = targetProgress - this.lastProgress;
        float progressChangeAmount = progressDiff * dt;
        float actualProgress = Mth.m_14036_((float)(this.lastProgress + progressChangeAmount), (float)0.0f, (float)1.0f);
        float lineLength = config.getBoolean(Options.BREAKING_PROGRESS_BOTTOM_ONLY) ? (float)(rect.width - 2) * actualProgress : (float)((rect.width + rect.height - 4) * 2) * actualProgress;
        if (lineLength > 0.0f) {
            int hLength = rect.width - 2;
            int vLength = rect.height - 4;
            int x = rect.x + 1;
            int y = rect.y + rect.height - 2;
            int color = config.getInt(Options.BREAKING_PROGRESS_COLOR);
            this.fill(ctx, x, y, (float)x + Math.min(lineLength, (float)hLength), y + 1, color);
            lineLength -= (float)hLength;
            if (lineLength > 0.0f) {
                x = rect.x + rect.width - 2;
                y = rect.y + rect.height - 2;
                this.fill(ctx, x, y, x + 1, (float)y - Math.min(lineLength, (float)vLength), color);
                lineLength -= (float)vLength;
                if (lineLength > 0.0f) {
                    x = rect.x + rect.width - 1;
                    y = rect.y + 1;
                    this.fill(ctx, x, y, (float)x - Math.min(lineLength, (float)hLength), y + 1, color);
                    lineLength -= (float)hLength;
                    if (lineLength > 0.0f) {
                        x = rect.x + 1;
                        y = rect.y + 2;
                        this.fill(ctx, x, y, x + 1, (float)y + Math.min(lineLength, (float)vLength), color);
                    }
                }
            }
            ctx.m_280262_();
        }
        this.wasBreaking = isBreaking;
        this.lastProgress = actualProgress;
        this.lastTargetProgress = targetProgress;
        if (isInDelay) {
            this.progressDelayTimer -= dt;
        }
    }

    private void fill(GuiGraphics ctx, float x1, float y1, float x2, float y2, int color) {
        float o;
        Matrix4f matrix4f = ctx.m_280168_().m_85850_().m_252922_();
        if (x1 < x2) {
            o = x1;
            x1 = x2;
            x2 = o;
        }
        if (y1 < y2) {
            o = y1;
            y1 = y2;
            y2 = o;
        }
        VertexConsumer vertexConsumer = ctx.m_280091_().m_6299_(RenderType.m_285907_());
        vertexConsumer.m_252986_(matrix4f, x1, y1, 0.0f).m_193479_(color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x1, y2, 0.0f).m_193479_(color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x2, y2, 0.0f).m_193479_(color).m_5752_();
        vertexConsumer.m_252986_(matrix4f, x2, y1, 0.0f).m_193479_(color).m_5752_();
    }
}

