/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncCapabilityPacket {
    private final int entityID;
    private final ItemStack backpack;
    private final boolean removeData;

    public ClientboundSyncCapabilityPacket(int entityID, ItemStack serverBackpack) {
        this(entityID, serverBackpack, false);
    }

    public ClientboundSyncCapabilityPacket(int entityID, ItemStack backpack, boolean removeData) {
        this.entityID = entityID;
        ItemStack backpackCopy = backpack.m_41777_();
        if (backpackCopy.m_41782_()) {
            backpackCopy.m_41783_().m_128473_("Inventory");
            backpackCopy.m_41783_().m_128473_("Upgrades");
        }
        this.backpack = backpackCopy;
        this.removeData = removeData;
    }

    public static ClientboundSyncCapabilityPacket decode(FriendlyByteBuf buffer) {
        int entityID = buffer.readInt();
        ItemStack backpack = buffer.m_130267_();
        boolean removeData = buffer.readBoolean();
        return new ClientboundSyncCapabilityPacket(entityID, backpack, removeData);
    }

    public static void encode(ClientboundSyncCapabilityPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityID);
        buffer.m_130055_(message.backpack);
        buffer.writeBoolean(message.removeData);
    }

    public static void handle(ClientboundSyncCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player playerEntity = (Player)Minecraft.m_91087_().f_91073_.m_6815_(message.entityID);
            LazyOptional<ITravelersBackpack> data = CapabilityUtils.getCapability(playerEntity);
            if (data.isPresent()) {
                if (message.removeData) {
                    ((ITravelersBackpack)data.resolve().get()).remove();
                } else {
                    ((ITravelersBackpack)data.resolve().get()).updateBackpack(message.backpack);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

