/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryActions {
    public static boolean transferContainerTank(TanksUpgrade upgrade, FluidTank tank, int slotIn) {
        LazyOptional fluidHandler;
        boolean hasFluidHandler;
        ItemStackHandler itemStackHandler = upgrade.getFluidSlotsHandler();
        ItemStack stackIn = itemStackHandler.getStackInSlot(slotIn);
        int slotOut = slotIn + 1;
        if (tank == null || stackIn.m_41619_() || stackIn.m_41720_() == Items.f_41852_) {
            return false;
        }
        if (stackIn.m_41720_() instanceof PotionItem && stackIn.m_41720_() != Items.f_42590_ && !(hasFluidHandler = FluidUtil.getFluidHandler((ItemStack)stackIn).isPresent())) {
            int amount = 250;
            FluidStack fluidStack = new FluidStack((Fluid)ModFluids.POTION_FLUID.get(), amount);
            FluidStackHelper.setFluidStackNBT(stackIn, fluidStack);
            if ((tank.isEmpty() || tank.getFluid().isFluidEqual(fluidStack)) && tank.getFluidAmount() + amount <= tank.getCapacity()) {
                ItemStack bottle = new ItemStack((ItemLike)Items.f_42590_);
                ItemStack currentStackOut = itemStackHandler.getStackInSlot(slotOut);
                if (currentStackOut.m_41619_() || currentStackOut.m_41720_() == bottle.m_41720_()) {
                    if (currentStackOut.m_41720_() == bottle.m_41720_()) {
                        if (currentStackOut.m_41613_() + 1 > currentStackOut.m_41741_()) {
                            return false;
                        }
                        bottle.m_41764_(itemStackHandler.getStackInSlot(slotOut).m_41613_() + 1);
                    }
                    tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    InventoryHelper.removeItem((IItemHandlerModifiable)upgrade.getFluidSlotsHandler(), slotIn, 1);
                    itemStackHandler.setStackInSlot(slotOut, bottle);
                    InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), SoundEvents.f_11772_, true);
                    return true;
                }
            }
        }
        if (stackIn.m_41720_() == Items.f_42590_ && tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get() && tank.getFluidAmount() >= 250) {
            ItemStack stackOut = FluidStackHelper.getItemStackFromFluidStack(tank.getFluid());
            ItemStack currentStackOut = itemStackHandler.getStackInSlot(slotOut);
            if (currentStackOut.m_41619_()) {
                tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
                InventoryHelper.removeItem((IItemHandlerModifiable)upgrade.getFluidSlotsHandler(), slotIn, 1);
                itemStackHandler.setStackInSlot(slotOut, stackOut);
                InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), SoundEvents.f_11772_, false);
                return true;
            }
        }
        if ((fluidHandler = FluidUtil.getFluidHandler((ItemStack)stackIn)).isPresent()) {
            ItemStack slotOutStack;
            ItemStack stackOut;
            SoundEvent fluidSound;
            FluidTank tankCopy;
            ItemStack stackInCopy;
            Optional fluidstack = FluidUtil.getFluidContained((ItemStack)stackIn);
            if (fluidstack.isPresent() && fluidstack.map(FluidStack::getAmount).orElse(0) > 0) {
                int amount = fluidstack.map(FluidStack::getAmount).orElse(0);
                if (tank.getFluidAmount() > 0 && !FluidStack.areFluidStackTagsEqual((FluidStack)tank.getFluid(), (FluidStack)fluidstack.orElse(FluidStack.EMPTY))) {
                    return false;
                }
                stackInCopy = stackIn.m_41777_();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                fluidSound = tank.getFluid().getFluid().getFluidType().getSound(tank.getFluid(), SoundActions.BUCKET_EMPTY);
                stackOut = FluidUtil.tryEmptyContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, null, (boolean)false).getResult();
                if (!stackOut.m_41619_() && ((slotOutStack = itemStackHandler.getStackInSlot(slotOut)).m_41619_() || slotOutStack.m_41720_() == stackOut.m_41720_())) {
                    if (slotOutStack.m_41720_() == stackOut.m_41720_()) {
                        stackOut.m_41764_(slotOutStack.m_41613_() + 1);
                        if (stackOut.m_41613_() > slotOutStack.m_41741_()) {
                            return false;
                        }
                    }
                    if (stackInCopy.m_41720_() == Items.f_42447_ && EnchantmentHelper.m_44831_((ItemStack)stackInCopy).containsKey(Enchantments.f_44952_)) {
                        stackOut = stackInCopy;
                    }
                    InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), fluidSound, false);
                    FluidUtil.tryEmptyContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, null, (boolean)true);
                    itemStackHandler.setStackInSlot(slotOut, stackOut);
                    InventoryHelper.removeItem((IItemHandlerModifiable)upgrade.getFluidSlotsHandler(), slotIn, 1);
                    return true;
                }
            }
            if (tank.isEmpty() || tank.getFluidAmount() <= 0) {
                return false;
            }
            if (InventoryActions.isFluidEqual(stackIn, tank)) {
                int amount = FluidUtil.getFluidHandler((ItemStack)stackIn).map(iFluidHandlerItem -> iFluidHandlerItem.getTankCapacity(0)).orElse(0);
                stackInCopy = stackIn.m_41777_();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                fluidSound = tank.getFluid().getFluid().getFluidType().getSound(tank.getFluid(), SoundActions.BUCKET_FILL);
                stackOut = FluidUtil.tryFillContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, null, (boolean)true).getResult();
                if (stackOut.m_41619_()) {
                    return false;
                }
                slotOutStack = itemStackHandler.getStackInSlot(slotOut);
                if (slotOutStack.m_41619_() || slotOutStack.m_41720_() == stackOut.m_41720_()) {
                    if (slotOutStack.m_41720_() == stackOut.m_41720_()) {
                        stackOut.m_41764_(slotOutStack.m_41613_() + 1);
                        if (stackOut.m_41613_() > slotOutStack.m_41741_()) {
                            return false;
                        }
                    }
                    InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), fluidSound, true);
                    FluidUtil.tryFillContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, null, (boolean)true);
                    itemStackHandler.setStackInSlot(slotOut, stackOut);
                    InventoryHelper.removeItem((IItemHandlerModifiable)upgrade.getFluidSlotsHandler(), slotIn, 1);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isFluidEqual(ItemStack stackIn, FluidTank tank) {
        if (FluidUtil.getFluidContained((ItemStack)stackIn).isPresent() && FluidUtil.getFluidContained((ItemStack)stackIn).map(FluidStack::getAmount).orElse(0) > 0) {
            return FluidUtil.getFluidContained((ItemStack)stackIn).map(fluidstack -> FluidStack.areFluidStackTagsEqual((FluidStack)fluidstack, (FluidStack)tank.getFluid())).orElse(false);
        }
        return !FluidUtil.getFluidContained((ItemStack)stackIn).isPresent();
    }

    public static void playFluidSound(@Nullable Player player, List<Player> usingPlayers, SoundEvent soundEvent, boolean fill) {
        if (soundEvent == null) {
            soundEvent = fill ? SoundEvents.f_11781_ : SoundEvents.f_11778_;
        }
        if (player != null) {
            player.m_9236_().m_6263_(null, player.m_20182_().m_7096_(), player.m_20182_().m_7098_() + 0.5, player.m_20182_().m_7094_(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (!usingPlayers.isEmpty()) {
            BackpackBaseMenu menu;
            Player user = usingPlayers.get(0);
            AbstractContainerMenu abstractContainerMenu = user.f_36096_;
            if (abstractContainerMenu instanceof BackpackBlockEntityMenu) {
                menu = (BackpackBlockEntityMenu)abstractContainerMenu;
                Vec3 backpackPos = menu.getWrapper().getBackpackPos().m_252807_();
                ((BackpackBlockEntityMenu)menu).player.m_9236_().m_6263_(null, backpackPos.m_7096_(), backpackPos.m_7098_() + 0.5, backpackPos.m_7094_(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if ((abstractContainerMenu = user.f_36096_) instanceof BackpackItemMenu && (menu = (BackpackItemMenu)abstractContainerMenu).getWrapper().getScreenID() == 1 && !((BackpackItemMenu)menu).player.m_9236_().f_46443_) {
                ((BackpackItemMenu)menu).player.m_6330_(soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

