/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.rei;

import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundTabPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.forge.REIPluginCommon;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

@REIPluginCommon
public class ReiCompat
implements REIClientPlugin {
    public double getPriority() {
        return 0.0;
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)new BackpackTransferHandler());
    }

    public static class BackpackTransferHandler
    implements SimpleTransferHandler {
        public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
            if (!BackpackBaseMenu.class.isInstance(context.getMenu()) || !BuiltinPlugin.CRAFTING.equals(context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
                return TransferHandler.ApplicabilityResult.createNotApplicable();
            }
            AbstractContainerMenu abstractContainerMenu = context.getMenu();
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                if (menu.getWrapper().getUpgradeManager().craftingUpgrade.isPresent()) {
                    return TransferHandler.ApplicabilityResult.createApplicable();
                }
            }
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }

        public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
            AbstractContainerMenu abstractContainerMenu = context.getMenu();
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                return IntStream.range(menu.CRAFTING_GRID_START, menu.CRAFTING_GRID_START + 9).mapToObj(id -> SlotAccessor.fromSlot((Slot)context.getMenu().m_38853_(id))).toList();
            }
            return List.of();
        }

        public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
            AbstractContainerMenu abstractContainerMenu = context.getMenu();
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                int i;
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                ArrayList<SlotAccessor> list = new ArrayList<SlotAccessor>();
                for (i = 0; i < menu.BACKPACK_INV_END; ++i) {
                    list.add(SlotAccessor.fromSlot((Slot)menu.m_38853_(i)));
                }
                for (i = menu.PLAYER_INV_START; i < menu.PLAYER_HOT_END; ++i) {
                    if (menu.getWrapper().getScreenID() == 1 && menu.m_38853_(i) instanceof DisabledSlot) continue;
                    list.add(SlotAccessor.fromSlot((Slot)menu.m_38853_(i)));
                }
                return list;
            }
            return List.of();
        }

        public TransferHandler.Result handle(TransferHandler.Context context) {
            AbstractContainerMenu abstractContainerMenu = context.getMenu();
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                CraftingUpgrade upgrade = menu.getWrapper().getUpgradeManager().craftingUpgrade.get();
                if (!upgrade.isTabOpened()) {
                    PacketDistributorHelper.sendToServer(new ServerboundTabPacket(upgrade.getDataHolderSlot(), true, 0));
                }
            }
            return this.handleSimpleTransfer(context, this.getMissingInputRenderer(), this.getInputsIndexed(context), this.getInputSlots(context), this.getInventorySlots(context));
        }
    }
}

