/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets.settings;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundSlotPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class MemoryWidget
extends SettingsWidgetBase {
    private final WidgetElement buttonElement = new WidgetElement(new Point(6, 22), new Point(18, 18));
    private final Point matchButtonUv = new Point(96, 36);
    private final Point ignoreButtonUv = new Point(114, 36);
    private final Point openTabUv = new Point(203, 0);
    private final Point iconUv = new Point(78, 0);
    private final Point iconHighlightedUv = new Point(78, 18);
    public boolean matchComponents;
    private static final List<Component> IGNORE_MODE_TOOLTIPS = List.of(Component.m_237115_((String)"screen.travelersbackpack.filter_match_components"), Component.m_237115_((String)"screen.travelersbackpack.filter_ignore_components"));

    public MemoryWidget(BackpackSettingsScreen screen, Point pos, boolean matchComponents) {
        super(screen, pos, new Point(30, 46));
        this.matchComponents = matchComponents;
    }

    public boolean isTabOpened() {
        return this.tabOpened;
    }

    public void sendDataToServer() {
        if (!((BackpackSettingsScreen)this.screen).memorySlots.equals(((BackpackSettingsScreen)this.screen).lastMemorySlots)) {
            ((BackpackSettingsScreen)this.screen).memorySlots.sort(Comparator.comparingInt(Pair::getFirst));
            PacketDistributorHelper.sendToServer(new ServerboundSlotPacket(1, ((BackpackSettingsScreen)this.screen).memorySlots));
            ((BackpackSettingsScreen)this.screen).lastMemorySlots.clear();
            ((BackpackSettingsScreen)this.screen).lastMemorySlots.addAll(((BackpackSettingsScreen)this.screen).memorySlots);
        }
    }

    public boolean contains(int index, List<Pair<Integer, Pair<ItemStack, Boolean>>> memory) {
        for (Pair<Integer, Pair<ItemStack, Boolean>> memoryPairs : memory) {
            if ((Integer)memoryPairs.getFirst() != index) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.tabOpened) {
            guiGraphics.m_280218_(BackpackScreen.TABS, this.pos.x(), this.pos.y(), this.openTabUv.x(), this.openTabUv.y(), this.openTabSize.x(), this.openTabSize.y());
            guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + 3, this.pos.y() + 3, this.iconHighlightedUv.x(), this.iconHighlightedUv.y(), this.iconSize.x(), this.iconSize.y());
            Point buttonUv = this.matchComponents ? this.matchButtonUv : this.ignoreButtonUv;
            guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + this.buttonElement.pos().x(), this.pos.y() + this.buttonElement.pos().y(), buttonUv.x(), buttonUv.y(), this.buttonElement.size().x(), this.buttonElement.size().y());
        } else {
            guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x(), this.pos.y(), this.emptyTabUv.x(), this.emptyTabUv.y(), this.width, this.height);
            guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + 3, this.pos.y() + 3, this.iconUv.x(), this.iconUv.y(), this.iconSize.x(), this.iconSize.y());
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isTabOpened() && this.isMouseOverMatchComponentsButton(mouseX, mouseY)) {
            guiGraphics.m_280557_(((BackpackSettingsScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.matchComponents ? 0 : 1), mouseX, mouseY);
        }
        if (this.isMouseOverIcon(mouseX, mouseY)) {
            guiGraphics.m_280666_(((BackpackSettingsScreen)this.screen).getFont(), TextUtils.getTranslatedSplittedText("screen.travelersbackpack.memory", null), mouseX, mouseY);
        }
    }

    public boolean isMouseOverMatchComponentsButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.buttonElement);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened() && this.isMouseOverMatchComponentsButton(pMouseX, pMouseY)) {
            this.matchComponents = !this.matchComponents;
            ((BackpackSettingsScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isMouseOverIcon(pMouseX, pMouseY)) {
            this.tabOpened = !this.tabOpened;
            ((BackpackSettingsScreen)this.screen).updateWidgetsPosition(this);
            if (!this.tabOpened) {
                this.sendDataToServer();
            }
            ((BackpackSettingsScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }
}

