/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.azure;

import com.zigythebird.playeranimatorapi.azure.ModAzureUtilsClient;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import com.zigythebird.playeranimatorapi.registry.AzureControllerRegistry;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.network.SerializableDataTicket;
import mod.azure.azurelib.network.packet.AnimDataSyncPacket;
import mod.azure.azurelib.network.packet.AnimTriggerPacket;
import mod.azure.azurelib.platform.Services;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class AnimatablePlayerLayer
implements GeoAnimatable {
    private final AbstractClientPlayer player;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimatablePlayerLayer(AbstractClientPlayer player) {
        this.player = player;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        CustomModifierLayer layer = PlayerAnimations.getModifierLayer(this.player);
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", state -> PlayState.CONTINUE).setOverrideEasingTypeFunction(azurePlayer -> ModAzureUtilsClient.getEasingTypeForID((Player)this.player))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(0, layer))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(1, layer))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(2, layer))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(3, layer))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(4, layer))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return (D)this.getAnimatableInstanceCache().getManagerForId((long)this.player.m_19879_()).getData(dataTicket);
    }

    public <D> void setAnimData(Entity relatedEntity, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).setData(dataTicket, data);
        } else {
            this.syncAnimData(instanceId, dataTicket, data, relatedEntity);
        }
    }

    public <D> void syncAnimData(long instanceId, SerializableDataTicket<D> dataTicket, D data, Entity entityToTrack) {
        Services.NETWORK.sendToTrackingEntityAndSelf((AbstractPacket)new AnimDataSyncPacket(this.getClass().toString(), instanceId, dataTicket, data), entityToTrack);
    }

    public void triggerAnim(Entity relatedEntity, long instanceId, @Nullable String controllerName, String animName) {
        if (relatedEntity.m_9236_().m_5776_()) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).tryTriggerAnimation(controllerName, animName);
        } else {
            Services.NETWORK.sendToTrackingEntityAndSelf((AbstractPacket)new AnimTriggerPacket(this.getClass().toString(), instanceId, controllerName, animName), relatedEntity);
        }
    }

    public double getTick(Object object) {
        return RenderUtils.getCurrentTick();
    }

    public AbstractClientPlayer getPlayer() {
        return this.player;
    }
}

