/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.EitherCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.stargate.Address;

public class Stargate {
    public static final String DIMENSION = "Dimension";
    public static final String COORDINATES = "Coordinates";
    public static final String HAS_DHD = "HasDHD";
    public static final String GENERATION = "Generation";
    public static final String TIMES_OPENED = "TimesOpened";
    public static final String NETWORK = "Network";
    private final Address.Immutable address;
    private final ResourceKey<Level> dimension;
    private final BlockPos blockPos;
    private boolean hasDHD;
    private Gen generation;
    private int timesOpened;
    private int network;

    public Stargate(Address.Immutable address, ResourceKey<Level> dimension, BlockPos blockPos, boolean hasDHD, Gen generation, int timesOpened, int network) {
        this.address = address;
        this.dimension = dimension;
        this.blockPos = blockPos;
        this.hasDHD = hasDHD;
        this.generation = generation;
        this.timesOpened = timesOpened;
        this.network = network;
    }

    public Stargate(AbstractStargateEntity stargate) {
        this(stargate.get9ChevronAddress().immutable(), (ResourceKey<Level>)stargate.m_58904_().m_46472_(), stargate.m_58899_(), stargate.hasDHD(), stargate.getGeneration(), stargate.getTimesOpened(), stargate.getNetwork());
    }

    public Address.Immutable get9ChevronAddress() {
        return this.address;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public boolean hasDHD() {
        return this.hasDHD;
    }

    public Gen getGeneration() {
        return this.generation;
    }

    public int getTimesOpened() {
        return this.timesOpened;
    }

    public int getNetwork() {
        return this.network;
    }

    public Optional<AbstractStargateEntity> getStargateEntity(MinecraftServer server) {
        BlockEntity blockEntity;
        ServerLevel level = server.m_129880_(this.dimension);
        if (level != null && (blockEntity = level.m_7702_(this.blockPos)) instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return Optional.of(stargate);
        }
        return Optional.empty();
    }

    public Feedback resetStargate(MinecraftServer server, Feedback feedback, boolean updateInterfaces) {
        Optional<AbstractStargateEntity> stargateEntity = this.getStargateEntity(server);
        if (stargateEntity.isPresent()) {
            return stargateEntity.get().resetStargate(feedback, updateInterfaces);
        }
        return feedback;
    }

    public Feedback resetStargate(MinecraftServer server, Feedback feedback) {
        Optional<AbstractStargateEntity> stargateEntity = this.getStargateEntity(server);
        if (stargateEntity.isPresent()) {
            return stargateEntity.get().resetStargate(feedback);
        }
        return feedback;
    }

    public boolean isConnected(MinecraftServer server) {
        Optional<AbstractStargateEntity> stargateEntity = this.getStargateEntity(server);
        if (stargateEntity.isPresent()) {
            return stargateEntity.get().isConnected();
        }
        return false;
    }

    public boolean isObstructed(MinecraftServer server) {
        Optional<AbstractStargateEntity> stargateEntity = this.getStargateEntity(server);
        if (stargateEntity.isPresent()) {
            return stargateEntity.get().isConnected();
        }
        return false;
    }

    public boolean canExtractEnergy(MinecraftServer server, long energy) {
        Optional<AbstractStargateEntity> stargateEntity = this.getStargateEntity(server);
        if (stargateEntity.isPresent()) {
            return stargateEntity.get().canExtractEnergy(energy);
        }
        return false;
    }

    public void depleteEnergy(MinecraftServer server, long energy, boolean simulate) {
        Optional<AbstractStargateEntity> stargateEntity = this.getStargateEntity(server);
        if (stargateEntity.isPresent()) {
            stargateEntity.get().depleteEnergy(energy, simulate);
        }
    }

    public void update(AbstractStargateEntity stargate) {
        this.hasDHD = stargate.hasDHD();
        this.generation = stargate.getGeneration();
        this.timesOpened = stargate.getTimesOpened();
        this.network = stargate.getNetwork();
    }

    public String toString() {
        return "[ " + this.address.toString() + " | DHD: " + this.hasDHD + " | Generation: " + this.generation + " | Times Opened: " + this.timesOpened + " ]";
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkStargateEntity(MinecraftServer server) {
        Optional<AbstractStargateEntity> stargateOptional = this.getStargateEntity(server);
        if (!stargateOptional.isPresent()) {
            StargateJourney.LOGGER.error("Stargate not found");
            return false;
        }
        AbstractStargateEntity stargate = stargateOptional.get();
        if (stargate == null) {
            StargateJourney.LOGGER.error("Stargate does not exist");
            return false;
        }
        stargate.checkStargate();
        return true;
    }

    public CompoundTag serialize() {
        CompoundTag stargateTag = new CompoundTag();
        ResourceKey<Level> level = this.getDimension();
        BlockPos pos = this.getBlockPos();
        stargateTag.m_128359_(DIMENSION, level.m_135782_().toString());
        stargateTag.m_128385_(COORDINATES, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        stargateTag.m_128379_(HAS_DHD, this.hasDHD);
        stargateTag.m_128405_(GENERATION, this.generation.getGen());
        stargateTag.m_128405_(TIMES_OPENED, this.timesOpened);
        stargateTag.m_128405_(NETWORK, this.network);
        return stargateTag;
    }

    public static Stargate deserialize(MinecraftServer server, Address.Immutable address, CompoundTag tag) {
        ResourceKey<Level> dimension = Conversion.stringToDimension(tag.m_128461_(DIMENSION));
        BlockPos blockPos = Conversion.intArrayToBlockPos(tag.m_128465_(COORDINATES));
        if (!(tag.m_128441_(HAS_DHD) && tag.m_128441_(GENERATION) && tag.m_128441_(TIMES_OPENED) && tag.m_128441_(NETWORK))) {
            BlockEntity blockEntity = server.m_129880_(dimension).m_7702_(blockPos);
            if (blockEntity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                return new Stargate(stargate);
            }
            StargateJourney.LOGGER.info("Failed to deserialize Stargate " + address.toString());
            return null;
        }
        boolean hasDHD = tag.m_128471_(HAS_DHD);
        Gen generation = Gen.intToGen(tag.m_128451_(GENERATION));
        int timesOpened = tag.m_128451_(TIMES_OPENED);
        int network = tag.m_128451_(NETWORK);
        return new Stargate(address, dimension, blockPos, hasDHD, generation, timesOpened, network);
    }

    private static Component createInfo(String feedback) {
        return Component.m_237115_((String)("message.sgjourney.stargate.info." + feedback));
    }

    private static Component createError(String feedback, boolean majorError) {
        MutableComponent component = Component.m_237115_((String)("message.sgjourney.stargate.error." + feedback));
        return majorError ? component.m_130940_(ChatFormatting.DARK_RED) : component.m_130940_(ChatFormatting.RED);
    }

    public static enum Gen {
        NONE(0),
        GEN_1(1),
        GEN_2(2),
        GEN_3(3);

        private final int gen;

        private Gen(int gen) {
            this.gen = gen;
        }

        public int getGen() {
            return this.gen;
        }

        public boolean isNewer(Gen generation) {
            return this.gen > generation.gen;
        }

        public static Gen intToGen(int gen) {
            switch (gen) {
                case 1: {
                    return GEN_1;
                }
                case 2: {
                    return GEN_2;
                }
                case 3: {
                    return GEN_3;
                }
            }
            return NONE;
        }
    }

    public static enum Feedback {
        NONE(0, FeedbackType.INFO, "none"),
        UNKNOWN_ERROR(-1, FeedbackType.ERROR, "unknown"),
        SYMBOL_ENCODED(1, FeedbackType.INFO, "symbol_encoded"),
        SYMBOL_IN_ADDRESS(-2, FeedbackType.ERROR, "symbol_in_address"),
        SYMBOL_OUT_OF_BOUNDS(-3, FeedbackType.ERROR, "symbol_out_of_bounds"),
        ENCODE_WHEN_CONNECTED(-4, FeedbackType.ERROR, "encode_when_connected"),
        CONNECTION_ESTABLISHED_SYSTEM_WIDE(2, FeedbackType.INFO, "connection_established.system_wide"),
        CONNECTION_ESTABLISHED_INTERSTELLAR(3, FeedbackType.INFO, "connection_established.interstellar"),
        CONNECTION_ESTABLISHED_INTERGALACTIC(4, FeedbackType.INFO, "connection_established.intergalactic"),
        INCOMPLETE_ADDRESS(-5, FeedbackType.MAJOR_ERROR, "incomplete_address"),
        INVALID_ADDRESS(-6, FeedbackType.MAJOR_ERROR, "invalid_address"),
        NOT_ENOUGH_POWER(-7, FeedbackType.MAJOR_ERROR, "not_enough_power"),
        SELF_OBSTRUCTED(-8, FeedbackType.MAJOR_ERROR, "self_obstructed"),
        TARGET_OBSTRUCTED(-9, FeedbackType.MAJOR_ERROR, "target_obstructed"),
        SELF_DIAL(-10, FeedbackType.MAJOR_ERROR, "self_dial"),
        SAME_SYSTEM_DIAL(-11, FeedbackType.MAJOR_ERROR, "same_system_dial"),
        ALREADY_CONNECTED(-12, FeedbackType.MAJOR_ERROR, "already_connected"),
        NO_GALAXY(-13, FeedbackType.MAJOR_ERROR, "no_galaxy"),
        NO_DIMENSIONS(-14, FeedbackType.MAJOR_ERROR, "no_dimensions"),
        NO_STARGATES(-15, FeedbackType.MAJOR_ERROR, "no_stargates"),
        TARGET_RESTRICTED(-16, FeedbackType.MAJOR_ERROR, "target_restricted"),
        INVALID_8_CHEVRON_ADDRESS(-17, FeedbackType.MAJOR_ERROR, "invalid_8_chevron_address"),
        INVALID_SYSTEM_WIDE_CONNECTION(-18, FeedbackType.MAJOR_ERROR, "invalid_system_wide_connection"),
        WHITELISTED_TARGET(-19, FeedbackType.MAJOR_ERROR, "whitelisted_target"),
        WHITELISTED_SELF(-20, FeedbackType.MAJOR_ERROR, "whitelisted_self"),
        BLACKLISTED_TARGET(-21, FeedbackType.MAJOR_ERROR, "blacklisted_target"),
        BLACKLISTED_SELF(-22, FeedbackType.MAJOR_ERROR, "blacklisted_self"),
        CONNECTION_ENDED_BY_DISCONNECT(7, FeedbackType.INFO, "connection_ended.disconnect"),
        CONNECTION_ENDED_BY_POINT_OF_ORIGIN(8, FeedbackType.INFO, "connection_ended.point_of_origin"),
        CONNECTION_ENDED_BY_NETWORK(9, FeedbackType.INFO, "connection_ended.stargate_network"),
        CONNECTION_ENDED_BY_AUTOCLOSE(10, FeedbackType.INFO, "connection_ended.autoclose"),
        EXCEEDED_CONNECTION_TIME(-23, FeedbackType.ERROR, "exceeded_connection_time"),
        RAN_OUT_OF_POWER(-24, FeedbackType.ERROR, "ran_out_of_power"),
        CONNECTION_REROUTED(-25, FeedbackType.ERROR, "connection_rerouted"),
        WRONG_DISCONNECT_SIDE(-26, FeedbackType.ERROR, "wrong_disconnect_side"),
        CONNECTION_FORMING(-27, FeedbackType.ERROR, "connection_forming"),
        STARGATE_DESTROYED(-28, FeedbackType.ERROR, "stargate_destroyed"),
        COULD_NOT_REACH_TARGET_STARGATE(-29, FeedbackType.MAJOR_ERROR, "could_not_reach_target_stargate"),
        INTERRUPTED_BY_INCOMING_CONNECTION(-30, FeedbackType.ERROR, "interrupted_by_incoming_connection"),
        CHEVRON_RAISED(11, FeedbackType.INFO, "chevron_opened"),
        ROTATING(12, FeedbackType.INFO, "rotating"),
        ROTATION_BLOCKED(-31, FeedbackType.INFO, "rotation_blocked"),
        NOT_ROTATING(-32, FeedbackType.INFO, "not_rotating"),
        ROTATION_STOPPED(13, FeedbackType.INFO, "rotation_stopped"),
        CHEVRON_ALREADY_OPENED(-33, FeedbackType.ERROR, "chevron_already_opened"),
        CHEVRON_ALREADY_CLOSED(-34, FeedbackType.ERROR, "chevron_already_closed"),
        CHEVRON_NOT_RAISED(-35, FeedbackType.ERROR, "chevron_not_raised"),
        CANNOT_ENCODE_POINT_OF_ORIGIN(-36, FeedbackType.ERROR, "cannot_encode_point_of_origin");

        private int code;
        private final FeedbackType type;
        private final String message;
        private final Component feedbackMessage;

        private Feedback(int code, FeedbackType type, String message) {
            this.code = code;
            this.type = type;
            this.message = message;
            this.feedbackMessage = type.isError() ? Stargate.createError(message, type == FeedbackType.MAJOR_ERROR) : Stargate.createInfo(message);
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Component getFeedbackMessage() {
            return this.feedbackMessage;
        }

        public boolean playFailSound() {
            return this.type.shouldPlaySound();
        }

        public boolean isError() {
            return this.type.isError();
        }
    }

    public static enum IrisMotion {
        IDLE(true),
        OPENING_REDSTONE(true),
        CLOSING_REDSTONE(true),
        OPENING_COMPUTER(false),
        CLOSING_COMPUTER(false);

        private boolean isRedstone;

        private IrisMotion(boolean isRedstone) {
            this.isRedstone = isRedstone;
        }

        public boolean isRedstone() {
            return this.isRedstone;
        }

        public boolean isOpening() {
            return this == OPENING_REDSTONE || this == OPENING_COMPUTER;
        }

        public boolean isClosing() {
            return this == CLOSING_REDSTONE || this == CLOSING_COMPUTER;
        }
    }

    public static enum ChevronSymbolState {
        OFF,
        ENCODED,
        ENGAGED;

    }

    public static class IncomingOutgoing<Thing> {
        public static final String OUTGOING = "outgoing";
        public static final String INCOMING = "incoming";
        private Thing outgoing;
        private Thing incoming;

        public IncomingOutgoing(Thing outgoing, Thing incoming) {
            this.outgoing = outgoing;
            this.incoming = incoming;
        }

        public IncomingOutgoing(Thing thing) {
            this.outgoing = thing;
            this.incoming = thing;
        }

        public Thing outgoing() {
            return this.outgoing;
        }

        public Thing incoming() {
            return this.incoming;
        }

        public Thing get(boolean incoming) {
            return incoming ? this.incoming : this.outgoing;
        }

        public static <Thing> Codec<IncomingOutgoing<Thing>> ioCodec(Codec<Thing> thing) {
            return RecordCodecBuilder.create(instance -> instance.group((App)thing.fieldOf(OUTGOING).forGetter(io -> io.outgoing), (App)thing.fieldOf(INCOMING).forGetter(io -> io.incoming)).apply((Applicative)instance, IncomingOutgoing::new));
        }

        public static <Thing> Codec<Either<IncomingOutgoing<Thing>, Thing>> bothCodec(Codec<Thing> thing) {
            return new EitherCodec(IncomingOutgoing.ioCodec(thing), thing);
        }
    }

    public static enum FeedbackType {
        INFO,
        ERROR,
        MAJOR_ERROR;


        public boolean isError() {
            return this == ERROR || this == MAJOR_ERROR;
        }

        public boolean shouldPlaySound() {
            return this == MAJOR_ERROR;
        }
    }

    public static enum FilterType {
        NONE(0),
        WHITELIST(1),
        BLACKLIST(-1);

        private int integerValue;

        private FilterType(int integerValue) {
            this.integerValue = integerValue;
        }

        public int getIntegerValue() {
            return this.integerValue;
        }

        public boolean shouldFilter() {
            return this != NONE;
        }

        public boolean isWhitelist() {
            return this == WHITELIST;
        }

        public boolean isBlacklist() {
            return this == BLACKLIST;
        }

        public static FilterType getFilterType(int integerValue) {
            switch (integerValue) {
                case 1: {
                    return WHITELIST;
                }
                case -1: {
                    return BLACKLIST;
                }
            }
            return NONE;
        }
    }

    public static enum WormholeTravel {
        ENABLED,
        CREATIVE_ONLY,
        DISABLED;

    }

    public static enum ChevronLockSpeed {
        SLOW(3),
        MEDIUM(2),
        FAST(1);

        private int multiplier;

        private ChevronLockSpeed(int multiplier) {
            this.multiplier = multiplier;
        }

        public int getMultiplier() {
            return this.multiplier;
        }

        public int getChevronWaitTicks() {
            return this.multiplier * 4;
        }

        public int getKawooshStartTicks() {
            return this.getChevronWaitTicks() * 9;
        }
    }
}

