/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class SGJourneyJigsawPlacement
extends JigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext p_227239_, Holder<StructureTemplatePool> p_227240_, Optional<ResourceLocation> p_227241_, int p_227242_, BlockPos p_227243_, boolean p_227244_, Optional<Heightmap.Types> p_227245_, int p_227246_, Rotation rotation) {
        BlockPos blockpos;
        RegistryAccess registryaccess = p_227239_.f_226621_();
        ChunkGenerator chunkgenerator = p_227239_.f_226622_();
        StructureTemplateManager structuretemplatemanager = p_227239_.f_226625_();
        LevelHeightAccessor levelheightaccessor = p_227239_.f_226629_();
        WorldgenRandom worldgenrandom = p_227239_.f_226626_();
        Registry registry = registryaccess.m_175515_(Registries.f_256948_);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)p_227240_.m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_227355_((RandomSource)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        if (p_227241_.isPresent()) {
            ResourceLocation resourcelocation = p_227241_.get();
            Optional optional = SGJourneyJigsawPlacement.m_227247_((StructurePoolElement)structurepoolelement, (ResourceLocation)resourcelocation, (BlockPos)p_227243_, (Rotation)rotation, (StructureTemplateManager)structuretemplatemanager, (WorldgenRandom)worldgenrandom);
            if (optional.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourcelocation, (Object)((ResourceKey)p_227240_.m_203543_().get()).m_135782_());
                return Optional.empty();
            }
            blockpos = (BlockPos)optional.get();
        } else {
            blockpos = p_227243_;
        }
        BlockPos vec3i = blockpos.m_121996_((Vec3i)p_227243_);
        BlockPos blockpos1 = p_227243_.m_121996_((Vec3i)vec3i);
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuretemplatemanager, structurepoolelement, blockpos1, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_214015_(structuretemplatemanager, blockpos1, rotation));
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int k = p_227245_.isPresent() ? p_227243_.m_123342_() + chunkgenerator.m_223221_(i, j, p_227245_.get(), levelheightaccessor, p_227239_.f_226624_()) : blockpos1.m_123342_();
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        poolelementstructurepiece.m_6324_(0, k - l, 0);
        int i1 = k + vec3i.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, i1, j), p_227237_ -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (p_227242_ > 0) {
                AABB aabb = new AABB((double)(i - p_227246_), (double)(i1 - p_227246_), (double)(j - p_227246_), (double)(i + p_227246_ + 1), (double)(i1 + p_227246_ + 1), (double)(j + p_227246_ + 1));
                VoxelShape voxelshape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_);
                SGJourneyJigsawPlacement.m_227210_((RandomState)p_227239_.f_226624_(), (int)p_227242_, (boolean)p_227244_, (ChunkGenerator)chunkgenerator, (StructureTemplateManager)structuretemplatemanager, (LevelHeightAccessor)levelheightaccessor, (RandomSource)worldgenrandom, (Registry)registry, (PoolElementStructurePiece)poolelementstructurepiece, (List)list, (VoxelShape)voxelshape);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)p_227237_).m_142679_(arg_0));
            }
        }));
    }
}

