/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.stargate.Stargate;

public class ClassicStargateEntity
extends AbstractStargateEntity {
    public static final float CLASSIC_THICKNESS = 8.0f;
    public static final float HORIZONTAL_CENTER_CLASSIC_HEIGHT = 0.25f;
    private static final short ROTATION_TICK_DURATION = 40;
    private static final short CHEVRON_LOCK_TICK_DURATION = 20;
    private short rotationOld = 0;
    private short rotation = 0;
    public int[] addressBuffer = new int[0];
    public int symbolBuffer = 0;

    public ClassicStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.CLASSIC_STARGATE.get(), new ResourceLocation("sgjourney", "classic/classic"), pos, state, Stargate.Gen.NONE, 0, 0.5f, 0.25f);
        this.displayID = true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isPointOfOriginValid(this.m_58904_())) {
            this.setPointOfOriginFromDimension((ResourceKey<Level>)this.m_58904_().m_46472_());
        }
        if (!this.areSymbolsValid(this.m_58904_())) {
            this.setSymbolsFromDimension((ResourceKey<Level>)this.m_58904_().m_46472_());
        }
    }

    @Override
    public CompoundTag serializeStargateInfo(CompoundTag tag) {
        super.serializeStargateInfo(tag);
        tag.m_128359_("PointOfOrigin", this.pointOfOrigin);
        tag.m_128359_("Symbols", this.symbols);
        tag.m_128376_("Rotation", this.rotation);
        return tag;
    }

    @Override
    public void deserializeStargateInfo(CompoundTag tag, boolean isUpgraded) {
        if (tag.m_128441_("PointOfOrigin")) {
            this.pointOfOrigin = tag.m_128461_("PointOfOrigin");
        }
        if (tag.m_128441_("Symbols")) {
            this.symbols = tag.m_128461_("Symbols");
        }
        if (tag.m_128441_("Rotation")) {
            this.rotation = tag.m_128448_("Rotation");
        }
        super.deserializeStargateInfo(tag, isUpgraded);
    }

    public double angle() {
        return 10.0;
    }

    public short getRotation() {
        return this.rotation;
    }

    public void setRotation(short rotation) {
        this.rotation = rotation;
    }

    public int getCurrentSymbol() {
        int currentSymbol;
        double position = (double)(this.rotation * 2) / this.angle();
        if (position >= (double)(currentSymbol = (int)position) + 0.5) {
            ++currentSymbol;
        }
        if (currentSymbol > 38) {
            currentSymbol -= 39;
        }
        return currentSymbol;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ClassicStargateEntity stargate) {
        stargate.handleRotation();
        AbstractStargateEntity.tick(level, pos, state, stargate);
    }

    private void handleRotation() {
        this.rotationOld = this.rotation;
    }

    private void rotate() {
        this.rotation = (short)(this.rotation + 4);
    }

    public float getRotation(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.rotationOld, (float)this.rotation);
    }

    @Override
    public void playRotationSound() {
    }

    @Override
    public void stopRotationSound() {
    }

    @Override
    public Stargate.ChevronLockSpeed getChevronLockSpeed() {
        return (Stargate.ChevronLockSpeed)((Object)CommonStargateConfig.classic_chevron_lock_speed.get());
    }

    @Override
    public void registerInterfaceMethods(StargatePeripheralWrapper wrapper) {
        CCTweakedCompatibility.registerClassicStargateMethods(wrapper);
    }
}

