/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.dhd;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.dhd.CrystalDHDEntity;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.CallForwardingDevice;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;

public class MilkyWayDHDEntity
extends CrystalDHDEntity {
    public MilkyWayDHDEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.MILKY_WAY_DHD.get(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        MilkyWayDHDEntity.addTransferCrystals(this.itemHandler);
    }

    @Override
    protected SoundEvent getEnterSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_DHD_ENTER.get();
    }

    @Override
    protected SoundEvent getPressSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_DHD_PRESS.get();
    }

    @Override
    protected ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                MilkyWayDHDEntity.this.m_6596_();
                MilkyWayDHDEntity.this.recalculateCrystals();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    AbstractCrystalItem crystal;
                    Item item = stack.m_41720_();
                    return item instanceof AbstractCrystalItem && (crystal = (AbstractCrystalItem)item).isLarge();
                }
                return MilkyWayDHDEntity.this.isValidCrystal(stack) || stack.m_41720_() instanceof CallForwardingDevice;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public static void addTransferCrystals(ItemStackHandler itemHandler) {
        int slots = itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!stack.m_150930_((Item)ItemInit.ENERGY_CRYSTAL.get()) || !stack.m_41782_() || !stack.m_41783_().m_128461_("CrystalMode").equals("ENERGY_TRANSFER")) continue;
            itemHandler.setStackInSlot(i, new ItemStack((ItemLike)ItemInit.TRANSFER_CRYSTAL.get()));
            StargateJourney.LOGGER.info("Replaced Transfer Crystal");
        }
    }
}

