/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.util;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EnvironmentChecker {
    public static boolean IsPlayerLookingAtBlock(Minecraft client, Block block) {
        if (client.f_91074_ == null || client.f_91073_ == null) {
            return false;
        }
        HitResult hitResult = client.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult hitResult2 = (BlockHitResult)hitResult;
            BlockPos pos = hitResult2.m_82425_();
            BlockState state = client.f_91073_.m_8055_(pos);
            return state.m_60713_(block);
        }
        return false;
    }

    public static boolean IsPlayerHoldingItem(Minecraft client, Item item) {
        if (client.f_91074_ != null) {
            return client.f_91074_.m_21205_().m_150930_(item) || client.f_91074_.m_21206_().m_150930_(item);
        }
        return false;
    }

    public static boolean IsPlayerHoldingItemOfType(Minecraft client, Class<? extends Item> itemType) {
        if (client.f_91074_ == null) {
            return false;
        }
        return itemType.isInstance(client.f_91074_.m_21205_().m_41720_()) || itemType.isInstance(client.f_91074_.m_21206_().m_41720_());
    }

    public static boolean IsPlayerOnBlock(Minecraft client, Block block) {
        if (client.f_91074_ == null || client.f_91073_ == null) {
            return false;
        }
        BlockPos playerPos = client.f_91074_.m_20097_().m_7495_();
        return client.f_91073_.m_8055_(playerPos).m_60713_(block);
    }

    public static boolean HasSolidBlockNextToHeadLevel(Minecraft client, String direction) {
        if (client.f_91074_ == null || client.f_91073_ == null) {
            return false;
        }
        BlockPos playerPos = client.f_91074_.m_20097_();
        float yaw = client.f_91074_.m_6080_();
        yaw = (yaw + 360.0f) % 360.0f;
        int xOffset = 0;
        int zOffset = 0;
        switch (direction.toUpperCase()) {
            case "LEFT": {
                if (yaw >= 315.0f || yaw < 45.0f) {
                    xOffset = 1;
                    break;
                }
                if (yaw >= 45.0f && yaw < 135.0f) {
                    zOffset = 1;
                    break;
                }
                if (yaw >= 135.0f && yaw < 225.0f) {
                    xOffset = -1;
                    break;
                }
                if (!(yaw >= 225.0f)) break;
                zOffset = -1;
                break;
            }
            case "RIGHT": {
                if (yaw >= 315.0f || yaw < 45.0f) {
                    xOffset = -1;
                    break;
                }
                if (yaw >= 45.0f && yaw < 135.0f) {
                    zOffset = -1;
                    break;
                }
                if (yaw >= 135.0f && yaw < 225.0f) {
                    xOffset = 1;
                    break;
                }
                if (!(yaw >= 225.0f)) break;
                zOffset = 1;
                break;
            }
            case "BEHIND": {
                if (yaw >= 315.0f || yaw < 45.0f) {
                    zOffset = -1;
                    break;
                }
                if (yaw >= 45.0f && yaw < 135.0f) {
                    xOffset = -1;
                    break;
                }
                if (yaw >= 135.0f && yaw < 225.0f) {
                    zOffset = 1;
                    break;
                }
                if (!(yaw >= 225.0f)) break;
                xOffset = 1;
                break;
            }
            default: {
                if (yaw >= 315.0f || yaw < 45.0f) {
                    zOffset = 1;
                    break;
                }
                if (yaw >= 45.0f && yaw < 135.0f) {
                    xOffset = 1;
                    break;
                }
                if (yaw >= 135.0f && yaw < 225.0f) {
                    zOffset = -1;
                    break;
                }
                if (!(yaw >= 225.0f)) break;
                xOffset = -1;
            }
        }
        BlockPos checkPos = playerPos.m_7918_(xOffset, 1, zOffset);
        return client.f_91073_.m_8055_(checkPos).m_60815_();
    }

    public static boolean IsPlayerOnBlockOfType(Minecraft client, Class<? extends Block> blockType) {
        if (client.f_91074_ == null || client.f_91073_ == null) {
            return false;
        }
        BlockPos playerPos = client.f_91074_.m_20097_().m_7495_();
        Block block = client.f_91073_.m_8055_(playerPos).m_60734_();
        if (blockType.isInstance(block)) {
            return true;
        }
        if (block instanceof BedBlock) {
            return blockType.isInstance(block);
        }
        return false;
    }
}

