/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kosmx.playerAnim.core.util.MathHelper;
import java.util.ArrayList;
import me.vierdant.playeremotes.PlayeremotesClient;
import me.vierdant.playeremotes.data.Animation;
import me.vierdant.playeremotes.data.AnimationRegistry;
import me.vierdant.playeremotes.screen.widget.AbstractQuickWheelWidget;
import me.vierdant.playeremotes.screen.widget.IQuickWheel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class QuickWheel
implements IQuickWheel {
    public static int quickMenuPage = 0;
    protected final ArrayList<QuickWheelElement> elements = new ArrayList();
    private boolean hovered;
    private final ResourceLocation TEXTURE = new ResourceLocation("playeremotes", "textures/gui/quickwheel.png");
    private final AbstractQuickWheelWidget widget;

    public QuickWheel(AbstractQuickWheelWidget widget) {
        this.widget = widget;
        this.elements.add(new QuickWheelElement(0, 0.0f));
        this.elements.add(new QuickWheelElement(1, 45.0f));
        this.elements.add(new QuickWheelElement(2, 90.0f));
        this.elements.add(new QuickWheelElement(3, 135.0f));
        this.elements.add(new QuickWheelElement(4, 180.0f));
        this.elements.add(new QuickWheelElement(5, 225.0f));
        this.elements.add(new QuickWheelElement(6, 270.0f));
        this.elements.add(new QuickWheelElement(7, 315.0f));
    }

    protected QuickWheelElement getActivePart(int mouseX, int mouseY) {
        int x = mouseX - this.widget.x - this.widget.size / 2;
        int y = mouseY - this.widget.y - this.widget.size / 2;
        int i = 0;
        double pi = Math.PI;
        double distanceFromCenter = Math.sqrt(x * x + y * y);
        if (distanceFromCenter < (double)this.widget.size * 0.17 || distanceFromCenter > (double)this.widget.size / 2.0) {
            return null;
        }
        float degrees = (float)(Math.abs((Math.atan2(y, x) - pi) / (2.0 * pi) * 360.0 - 270.0) % 360.0);
        if ((double)degrees < 22.5) {
            i = 0;
        } else if ((double)degrees < 67.5) {
            i = 1;
        } else if ((double)degrees < 112.5) {
            i = 2;
        } else if ((double)degrees < 157.5) {
            i = 3;
        } else if ((double)degrees < 202.5) {
            i = 4;
        } else if ((double)degrees < 247.5) {
            i = 5;
        } else if ((double)degrees < 292.5) {
            i = 6;
        } else if ((double)degrees < 337.5) {
            i = 7;
        }
        return this.elements.get(i);
    }

    private int getPageButton(int mouseX, int mouseY) {
        int x = mouseX - this.widget.x - this.widget.size / 2;
        int y = mouseY - this.widget.y - this.widget.size / 2;
        double distanceFromCenter = Math.sqrt(x * x + y * y);
        if (distanceFromCenter < (double)this.widget.size * 0.17 || distanceFromCenter > (double)this.widget.size / 2.0) {
            if (x > 1) {
                return 1;
            }
            if (x < 1) {
                return 0;
            }
        }
        return -1;
    }

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Object part;
        this.checkHovered(mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.drawTexture(context, this.TEXTURE, 0, 0, 0, 0, 2);
        if (this.hovered && (part = this.getActivePart(mouseX, mouseY)) != null && this.widget.doHoverPart((IQuickWheel.IQuickElement)part)) {
            ((QuickWheelElement)part).renderHover(context, this.TEXTURE);
        }
        for (QuickWheelElement element : this.elements) {
            if (!element.hasAnimation()) continue;
            element.render(context);
        }
        String text = String.valueOf(quickMenuPage + 1);
        context.m_280056_(Minecraft.m_91087_().f_91062_, text, (int)((float)this.widget.x + (float)this.widget.size / 2.0f - 2.0f), (int)((float)this.widget.y + (float)this.widget.size / 2.0f - 3.0f), MathHelper.colorHelper((int)255, (int)255, (int)255, (int)1), false);
    }

    private void drawTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int u, int v, int s) {
        context.m_280411_(texture, this.widget.x + x * this.widget.size / 256, this.widget.y + y * this.widget.size / 256, s * this.widget.size / 2, s * this.widget.size / 2, (float)u, (float)v, s * 128, s * 128, 512, 512);
    }

    private void drawTextureSelect(GuiGraphics context, ResourceLocation texture, int x, int y, int u, int v, int w, int h) {
        context.m_280411_(texture, this.widget.x + x * this.widget.size / 512, this.widget.y + y * this.widget.size / 512, w * this.widget.size / 2, h * this.widget.size / 2, (float)u, (float)v, w * 128, h * 128, 512, 512);
    }

    private void checkHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.widget.x && mouseY >= this.widget.y && mouseX <= this.widget.x + this.widget.size && mouseY <= this.widget.y + this.widget.size;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.checkHovered((int)mouseX, (int)mouseY);
        if (this.hovered && this.widget.isValidClickButton(button)) {
            QuickWheelElement element = this.getActivePart((int)mouseX, (int)mouseY);
            if (element != null) {
                return this.widget.onClick(element, button);
            }
            int selectedPageButton = this.getPageButton((int)mouseX, (int)mouseY);
            if (selectedPageButton == 0) {
                quickMenuPage = quickMenuPage > 0 ? --quickMenuPage : 9;
            } else if (selectedPageButton == 1) {
                quickMenuPage = quickMenuPage < 9 ? ++quickMenuPage : 0;
            }
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        this.checkHovered((int)mouseX, (int)mouseY);
        if (amount < 0.0) {
            if (quickMenuPage < 9) {
                ++quickMenuPage;
                return true;
            }
        } else if (quickMenuPage > 0) {
            --quickMenuPage;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        this.checkHovered((int)mouseX, (int)mouseY);
        return this.hovered;
    }

    protected class QuickWheelElement
    implements IQuickWheel.IQuickElement {
        private final float angle;
        private final int id;

        protected QuickWheelElement(int number, float angle) {
            this.angle = angle;
            this.id = number;
        }

        @Override
        public boolean hasAnimation() {
            return PlayeremotesClient.config.getQuickWheelEntry(quickMenuPage, this.id) != null;
        }

        @Override
        public Animation getAnimation() {
            String animationName = PlayeremotesClient.config.getQuickWheelEntry(quickMenuPage, this.id);
            if (animationName == null) {
                return null;
            }
            return AnimationRegistry.getAnimation(animationName);
        }

        @Override
        public void clearAnimation() {
            PlayeremotesClient.config.setQuickWheelEntry(quickMenuPage, this.id, null);
        }

        @Override
        public void setAnimation(Animation animation) {
            PlayeremotesClient.config.setQuickWheelEntry(quickMenuPage, this.id, animation.id.m_135815_());
        }

        public void render(GuiGraphics context) {
            ResourceLocation iconId;
            String animationName = PlayeremotesClient.config.getQuickWheelEntry(quickMenuPage, this.id) != null ? PlayeremotesClient.config.getQuickWheelEntry(quickMenuPage, this.id) : null;
            Animation animation = animationName != null ? AnimationRegistry.getAnimation(animationName) : null;
            ResourceLocation resourceLocation = iconId = animation != null ? animation.getIconIdentifier() : null;
            if (animation == null) {
                this.clearAnimation();
                return;
            }
            if (iconId != null && PlayeremotesClient.config.showIcons) {
                int s = QuickWheel.this.widget.size / 10;
                int iconX = (int)((double)(QuickWheel.this.widget.x + QuickWheel.this.widget.size / 2) + (double)QuickWheel.this.widget.size * 0.36 * Math.sin((double)this.angle * 0.0174533)) - s;
                int iconY = (int)((double)(QuickWheel.this.widget.y + QuickWheel.this.widget.size / 2) + (double)QuickWheel.this.widget.size * 0.36 * Math.cos((double)this.angle * 0.0174533)) - s;
                context.m_280411_(iconId, iconX, iconY, s * 2, s * 2, 0.0f, 0.0f, 256, 256, 256, 256);
            } else {
                QuickWheel.this.widget.drawCenteredText(context, animation.id.m_135815_(), this.angle);
            }
        }

        public void renderHover(GuiGraphics context, ResourceLocation texture) {
            switch (this.id) {
                case 0: {
                    QuickWheel.this.drawTextureSelect(context, texture, 0, 258, 0, 384, 2, 1);
                    break;
                }
                case 1: {
                    QuickWheel.this.drawTextureSelect(context, texture, 258, 258, 384, 384, 1, 1);
                    break;
                }
                case 2: {
                    QuickWheel.this.drawTextureSelect(context, texture, 258, 0, 384, 0, 1, 2);
                    break;
                }
                case 3: {
                    QuickWheel.this.drawTextureSelect(context, texture, 258, -1, 384, 256, 1, 1);
                    break;
                }
                case 4: {
                    QuickWheel.this.drawTextureSelect(context, texture, 0, 0, 0, 256, 2, 1);
                    break;
                }
                case 5: {
                    QuickWheel.this.drawTextureSelect(context, texture, 1, 1, 256, 256, 1, 1);
                    break;
                }
                case 6: {
                    QuickWheel.this.drawTextureSelect(context, texture, 1, 0, 256, 0, 1, 2);
                    break;
                }
                case 7: {
                    QuickWheel.this.drawTextureSelect(context, texture, -1, 258, 256, 384, 1, 1);
                }
            }
        }
    }
}

