/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes;

import com.mojang.blaze3d.platform.InputConstants;
import me.vierdant.playeremotes.ModSuggests;
import me.vierdant.playeremotes.conditional.ConditionalLeanAnimation;
import me.vierdant.playeremotes.conditional.ConditionalRandomizeAnimation;
import me.vierdant.playeremotes.conditional.ConditionalSitAnimation;
import me.vierdant.playeremotes.config.ClientConfig;
import me.vierdant.playeremotes.data.Animation;
import me.vierdant.playeremotes.data.AnimationRegistry;
import me.vierdant.playeremotes.packet.ClientPacketManager;
import me.vierdant.playeremotes.screen.QuickWheelScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="playeremotes", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class PlayeremotesClient {
    private static final String KEY_CATEGORY = "key.categories.playeremotes";
    private static KeyMapping triggerKey;
    public static int animationRandomizerIndex;
    public static Animation currentAnimation;
    public static boolean hasAnimation;
    public static ClientConfig config;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        config = new ClientConfig(FMLPaths.CONFIGDIR.get().toString() + "/playeremotes.json");
        config.load();
        PlayeremotesClient.handleAnimationEntries();
        MinecraftForge.EVENT_BUS.register((Object)new PlayeremotesClient());
    }

    @SubscribeEvent
    public static void registerKeyBindEvent(RegisterKeyMappingsEvent event) {
        triggerKey = new KeyMapping("key.playeremotes.trigger", InputConstants.Type.KEYSYM, 66, KEY_CATEGORY);
        event.register(triggerKey);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft client = Minecraft.m_91087_();
            System.out.println("attmpt opened menu");
            while (triggerKey.m_90859_()) {
                System.out.println("opened menu");
                if (client.f_91074_ == null || client.f_91074_ != client.m_91288_()) continue;
                client.m_91152_((Screen)new QuickWheelScreen(null));
            }
            if (hasAnimation && client.f_91074_ != null && (client.f_91074_.m_6147_() || client.f_91074_.m_20159_() || this.isPlayerMoving(client))) {
                PlayeremotesClient.cancelAnimation();
            }
        }
    }

    private boolean isPlayerMoving(Minecraft client) {
        return client.f_91074_ != null && (client.f_91074_.f_108618_.f_108568_ || client.f_91074_.f_108618_.f_108569_ || client.f_91074_.f_108618_.f_108570_ || client.f_91074_.f_108618_.f_108571_);
    }

    public static void cancelAnimation() {
        ClientPacketManager.sendAnimationCancel(PlayeremotesClient.currentAnimation.id);
        hasAnimation = false;
        currentAnimation = null;
    }

    public static void playAnimation(Animation animation) {
        currentAnimation = animation.getConditionalAnimation(Minecraft.m_91087_());
        ClientPacketManager.sendAnimationRequest(PlayeremotesClient.currentAnimation.id, PlayeremotesClient.currentAnimation.excludeHead, PlayeremotesClient.currentAnimation.firstPersonOption);
        hasAnimation = true;
    }

    private static void handleAnimationEntries() {
        if (ModSuggests.hasSittingPlus) {
            AnimationRegistry.getAnimation("buttsit").setConditionalFunction(ConditionalSitAnimation::run);
        }
        AnimationRegistry.getAnimation("lean_to_left").setConditionalFunction(ConditionalLeanAnimation::run);
        AnimationRegistry.getAnimation("clap").setConditionalFunction(ConditionalRandomizeAnimation::run);
        AnimationRegistry.getAnimation("point").setConditionalFunction(ConditionalRandomizeAnimation::run);
        AnimationRegistry.getAnimation("facepalm").setConditionalFunction(ConditionalRandomizeAnimation::run);
        AnimationRegistry.getAnimation("cry").setConditionalFunction(ConditionalRandomizeAnimation::run);
        AnimationRegistry.getAnimation("kneel").setConditionalFunction(ConditionalRandomizeAnimation::run);
        AnimationRegistry.getAnimation("salute").setConditionalFunction(ConditionalRandomizeAnimation::run);
        AnimationRegistry.getAnimation("lay").setConditionalFunction(ConditionalRandomizeAnimation::run);
        AnimationRegistry.getAnimation("bow").setConditionalFunction(ConditionalRandomizeAnimation::run);
    }

    public static String getAnimationIndexValue(String[] list) {
        if (animationRandomizerIndex >= list.length) {
            animationRandomizerIndex = 0;
        }
        String value = list[animationRandomizerIndex];
        animationRandomizerIndex = (animationRandomizerIndex + 1) % list.length;
        return value;
    }

    static {
        animationRandomizerIndex = 0;
        hasAnimation = false;
    }
}

