/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;

public class MaLiLibConfigGui
extends GuiConfigsBase {
    private static ConfigGuiTab tab = ConfigGuiTab.GENERIC;

    public MaLiLibConfigGui() {
        super(10, 50, "mafglib", null, "malilib.gui.title.configs", "MaFgLib");
    }

    @Override
    public void initGui() {
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        for (ConfigGuiTab tab : ConfigGuiTab.values()) {
            x += this.createButton(x, y, -1, tab) + 2;
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(MaLiLibConfigGui.tab != tab);
        this.addButton(button, new ButtonListener(tab, this));
        return button.getWidth();
    }

    @Override
    protected int getConfigWidth() {
        ConfigGuiTab tab = MaLiLibConfigGui.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            return 200;
        }
        return super.getConfigWidth();
    }

    @Override
    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        ImmutableList<IConfigValue> configs;
        ConfigGuiTab tab = MaLiLibConfigGui.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            configs = MaLiLibConfigs.Generic.OPTIONS;
        } else if (tab == ConfigGuiTab.DEBUG) {
            configs = MaLiLibConfigs.Debug.OPTIONS;
        } else {
            return Collections.emptyList();
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    public static enum ConfigGuiTab {
        GENERIC("malilib.gui.title.generic"),
        DEBUG("malilib.gui.title.debug");

        private final String translationKey;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate(this.translationKey, new Object[0]);
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final MaLiLibConfigGui parent;
        private final ConfigGuiTab tab;

        public ButtonListener(ConfigGuiTab tab, MaLiLibConfigGui parent) {
            this.tab = tab;
            this.parent = parent;
        }

        @Override
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            this.parent.reCreateListWidget();
            ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
            this.parent.initGui();
        }
    }
}

