/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.util;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ConfigurableSpawns;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.CustomStructureData;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.ProgressionStructure;
import twilightforest.world.components.structures.util.StructureHints;

public abstract class ConquerableStructure
extends ProgressionStructure
implements CustomStructureData,
ConfigurableSpawns {
    protected final ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig;

    protected static <S extends ConquerableStructure> Products.P5<RecordCodecBuilder.Mu<S>, ControlledSpawns.ControlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig, StructureHints.HintConfig, DecorationClearance.DecorationConfig, Structure.StructureSettings> conquerStatusCodec(RecordCodecBuilder.Instance<S> instance) {
        return instance.group((App)ControlledSpawns.ControlledSpawningConfig.FLAT_CODEC.forGetter(ConquerableStructure::getConfig)).and(ConquerableStructure.progressionCodec(instance));
    }

    public ConquerableStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(advancementLockConfig, hintConfig, decorationConfig, structureSettings);
        this.controlledSpawningConfig = controlledSpawningConfig;
    }

    public StructureStart m_226596_(RegistryAccess registryAccess, ChunkGenerator chunkGen, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager templateManager, long seed, ChunkPos chunkPos, int references, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> isValidBiome) {
        return !(chunkGen.m_62218_() instanceof TFBiomeProvider) || LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkPos) ? this.generateCustom(registryAccess, chunkGen, biomeSource, randomState, templateManager, seed, chunkPos, references, heightAccessor, isValidBiome) : StructureStart.f_73561_;
    }

    public StructureStart generateCustom(RegistryAccess registryAccess, ChunkGenerator chunkGen, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager templateManager, long pseed, ChunkPos chunkPos, int references, LevelHeightAccessor heightAccessor, Predicate<Holder<Biome>> isValidBiome) {
        StructurePiecesBuilder structurepiecesbuilder;
        TFStructureStart structurestart;
        Structure.GenerationContext structure$generationcontext = new Structure.GenerationContext(registryAccess, chunkGen, biomeSource, randomState, templateManager, pseed, chunkPos, heightAccessor, isValidBiome);
        Optional optional = this.m_262864_(structure$generationcontext);
        if (optional.isPresent() && (structurestart = new TFStructureStart(this, chunkPos, references, (structurepiecesbuilder = ((Structure.GenerationStub)optional.get()).m_226677_()).m_192780_())).m_73603_()) {
            return structurestart;
        }
        return StructureStart.f_73561_;
    }

    @Override
    public ControlledSpawns.ControlledSpawningConfig getConfig() {
        return this.controlledSpawningConfig;
    }
}

