/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.trollcave;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.util.HugeMushroomUtil;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.trollcave.TrollCaveGardenComponent;
import twilightforest.world.components.structures.trollcave.TrollCaveMainComponent;

public class TrollCaveConnectComponent
extends TrollCaveMainComponent {
    protected static final Stalactite STONE_STALACTITE_SMALL = new Stalactite(Map.of(Blocks.f_50069_, 1), 1.0f, 5, 1);
    protected final boolean[] openingTowards = new boolean[]{false, false, true, false};

    public TrollCaveConnectComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFTCCon.get(), nbt);
        this.openingTowards[0] = nbt.m_128471_("openingTowards0");
        this.openingTowards[1] = nbt.m_128471_("openingTowards1");
        this.openingTowards[2] = nbt.m_128471_("openingTowards2");
        this.openingTowards[3] = nbt.m_128471_("openingTowards3");
    }

    public TrollCaveConnectComponent(int index, int x, int y, int z, int caveSize, int caveHeight, Direction direction) {
        super((StructurePieceType)TFStructurePieceTypes.TFTCCon.get(), index, x, y, z);
        this.size = caveSize;
        this.height = caveHeight;
        this.m_73519_(direction);
        this.f_73383_ = TFLandmark.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction, false);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128379_("openingTowards0", this.openingTowards[0]);
        tagCompound.m_128379_("openingTowards1", this.openingTowards[1]);
        tagCompound.m_128379_("openingTowards2", this.openingTowards[2]);
        tagCompound.m_128379_("openingTowards3", this.openingTowards[3]);
    }

    @Override
    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        if (this.m_73548_() < 3) {
            for (Rotation rotation : RotationUtil.ROTATIONS) {
                BlockPos dest = this.getValidOpening(rand, rotation);
                if (!rand.m_188499_() && this.makeGardenCave(list, rand, this.m_73548_() + 1, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), 30, 15, rotation)) continue;
                this.makeSmallerCave(list, rand, this.m_73548_() + 1, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), 20, 15, rotation);
            }
        }
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        int i;
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        RandomSource decoRNG = RandomSource.m_216335_((long)(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L));
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            if (this.openingTowards[rotation.ordinal()]) continue;
            this.decorateWall(world, sbb, decoRNG, rotation);
        }
        decoRNG.m_188584_(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L);
        for (i = 0; i < 32; ++i) {
            BlockPos.MutableBlockPos dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, STONE_STALACTITE_SMALL, (Vec3i)dest.m_175288_(this.height), sbb, true);
        }
        for (i = 0; i < 32; ++i) {
            BlockPos.MutableBlockPos dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, STONE_STALACTITE_SMALL, (Vec3i)dest.m_175288_(0), sbb, false);
        }
        decoRNG.m_188584_(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L);
        if (this.countExits() == 1 && decoRNG.m_188503_(3) == 0) {
            this.makeTreasureCrate(world, sbb);
        } else if (decoRNG.m_188503_(3) == 0) {
            this.makeMonolith(world, decoRNG, sbb);
        }
    }

    protected void makeMonolith(WorldGenLevel world, RandomSource rand, BoundingBox sbb) {
        int mid = this.size / 2;
        int height = 7 + rand.m_188503_(8);
        Rotation rotation = RotationUtil.ROTATIONS[rand.m_188503_(4)];
        this.fillBlocksRotated(world, sbb, mid - 1, 0, mid - 1, mid - 1, height, mid - 1, Blocks.f_50080_.m_49966_(), rotation);
        this.fillBlocksRotated(world, sbb, mid, 0, mid - 1, mid, height - 2, mid - 1, Blocks.f_50080_.m_49966_(), rotation);
        this.fillBlocksRotated(world, sbb, mid - 1, 0, mid, mid - 1, height - 2, mid, Blocks.f_50080_.m_49966_(), rotation);
        this.fillBlocksRotated(world, sbb, mid, 0, mid, mid, height - 4, mid, Blocks.f_50080_.m_49966_(), rotation);
    }

    private int countExits() {
        int count = 0;
        for (boolean openingToward : this.openingTowards) {
            if (!openingToward) continue;
            ++count;
        }
        return count;
    }

    private void decorateWall(WorldGenLevel world, BoundingBox sbb, RandomSource decoRNG, Rotation rotation) {
        if (decoRNG.m_188499_()) {
            this.decorateBracketMushrooms(world, sbb, decoRNG, rotation);
        } else if (decoRNG.m_188499_()) {
            this.decorateStoneFormation(world, sbb, decoRNG, rotation);
            this.decorateStoneFormation(world, sbb, decoRNG, rotation);
        }
    }

    private void decorateStoneFormation(WorldGenLevel world, BoundingBox sbb, RandomSource decoRNG, Rotation rotation) {
        int startY;
        int z = 5 + decoRNG.m_188503_(7);
        for (int y = startY = 1 + decoRNG.m_188503_(2); y < this.height; y += 2) {
            int width = 1;
            int depth = 1 + (decoRNG.m_188503_(3) == 0 ? 1 : 0);
            this.makeSingleStoneFormation(world, sbb, decoRNG, rotation, z, y, width, depth);
            if ((z += decoRNG.m_188503_(4) - decoRNG.m_188503_(4)) >= 5 && z <= this.size - 5) continue;
            z = 5 + decoRNG.m_188503_(7);
        }
    }

    private void makeSingleStoneFormation(WorldGenLevel world, BoundingBox sbb, RandomSource decoRNG, Rotation rotation, int z, int y, int width, int depth) {
        if (decoRNG.m_188503_(8) == 0) {
            this.fillBlocksRotated(world, sbb, this.size - (depth + 1), y - width, z - width, this.size - 1, y + width, z + width, Blocks.f_50080_.m_49966_(), rotation);
        } else if (decoRNG.m_188503_(4) == 0) {
            this.fillBlocksRotated(world, sbb, this.size - (depth + 1), y - width, z - width, this.size - 1, y + width, z + width, ((Block)TFBlocks.TROLLSTEINN.get()).m_49966_(), rotation);
        } else {
            this.fillBlocksRotated(world, sbb, this.size - (depth + 1), y - width, z - width, this.size - 1, y + width, z + width, Blocks.f_50069_.m_49966_(), rotation);
        }
    }

    private void decorateStoneProjection(WorldGenLevel world, BoundingBox sbb, RandomSource decoRNG, Rotation rotation) {
        int z = 7 + decoRNG.m_188503_(3) - decoRNG.m_188503_(3);
        int y = 7 + decoRNG.m_188503_(3) - decoRNG.m_188503_(3);
        this.randomlyFillBlocksRotated(world, sbb, decoRNG, 0.25f, this.size - 9, y, z, this.size - 2, y + 3, z + 3, ((Block)TFBlocks.TROLLSTEINN.get()).m_49966_(), Blocks.f_50069_.m_49966_(), rotation);
        if (decoRNG.m_188499_()) {
            this.randomlyFillBlocksRotated(world, sbb, decoRNG, 0.25f, this.size - 9, 1, z, this.size - 6, y - 1, z + 3, ((Block)TFBlocks.TROLLSTEINN.get()).m_49966_(), Blocks.f_50069_.m_49966_(), rotation);
        } else {
            this.randomlyFillBlocksRotated(world, sbb, decoRNG, 0.25f, this.size - 9, y + 4, z, this.size - 6, this.height - 2, z + 3, ((Block)TFBlocks.TROLLSTEINN.get()).m_49966_(), Blocks.f_50069_.m_49966_(), rotation);
        }
    }

    private void decorateBracketMushrooms(WorldGenLevel world, BoundingBox sbb, RandomSource decoRNG, Rotation rotation) {
        int startY;
        int z = 5 + decoRNG.m_188503_(7);
        for (int y = startY = 1 + decoRNG.m_188503_(4); y < this.height; y += 2) {
            int width = 1 + decoRNG.m_188503_(2) + decoRNG.m_188503_(2);
            int depth = 1 + decoRNG.m_188503_(2) + decoRNG.m_188503_(2);
            Block mushBlock = decoRNG.m_188503_(3) == 0 ? (Block)TFBlocks.HUGE_MUSHGLOOM.get() : (decoRNG.m_188499_() ? Blocks.f_50180_ : Blocks.f_50181_);
            this.makeSingleBracketMushroom(world, sbb, rotation, z, y, width, depth, mushBlock.m_49966_());
            if ((z += decoRNG.m_188503_(4) - decoRNG.m_188503_(4)) >= 5 && z <= this.size - 5) continue;
            z = 5 + decoRNG.m_188503_(7);
        }
    }

    private void makeSingleBracketMushroom(WorldGenLevel world, BoundingBox sbb, Rotation rotation, int z, int y, int width, int depth, BlockState mushBlock) {
        this.fillBlocksRotated(world, sbb, this.size - depth, y, z - (width - 1), this.size - 2, y, z + (width - 1), HugeMushroomUtil.getState(HugeMushroomUtil.HugeMushroomType.CENTER, mushBlock), rotation);
        this.fillBlocksRotated(world, sbb, this.size - (depth + 1), y, z - (width - 1), this.size - (depth + 1), y, z + (width - 1), this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.EAST), rotation);
        BlockState northMushroom = this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.SOUTH);
        for (int d = 0; d < depth - 1; ++d) {
            this.setBlockStateRotated(world, northMushroom, this.size - (2 + d), y, z - width, rotation, sbb);
        }
        BlockState northWestMushroom = this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.SOUTH_EAST);
        this.setBlockStateRotated(world, northWestMushroom, this.size - (depth + 1), y, z - width, rotation, sbb);
        BlockState southMushroom = this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.NORTH);
        for (int d = 0; d < depth - 1; ++d) {
            this.setBlockStateRotated(world, southMushroom, this.size - (2 + d), y, z + width, rotation, sbb);
        }
        BlockState southWestMushroom = this.getMushroomState(mushBlock, HugeMushroomUtil.HugeMushroomType.NORTH_EAST);
        this.setBlockStateRotated(world, southWestMushroom, this.size - (depth + 1), y, z + width, rotation, sbb);
    }

    private BlockState getMushroomState(BlockState mushroomBlockState, HugeMushroomUtil.HugeMushroomType defaultRotation) {
        return HugeMushroomUtil.getState(defaultRotation, mushroomBlockState);
    }

    protected boolean makeGardenCave(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int caveSize, int caveHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        BlockPos dest = this.offsetTowerCCoords(x, y, z, caveSize, direction);
        TrollCaveGardenComponent cave = new TrollCaveGardenComponent(index, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), caveSize, caveHeight, direction);
        StructurePiece intersect = list.m_141921_(cave.m_73547_());
        StructurePiece otherGarden = this.findNearbyGarden(list, cave.m_73547_());
        if ((intersect == null || intersect == this) && otherGarden == null) {
            list.m_142679_((StructurePiece)cave);
            ((TrollCaveMainComponent)cave).m_214092_(this, list, rand);
            this.openingTowards[rotation.ordinal()] = true;
            return true;
        }
        return false;
    }

    @Nullable
    private StructurePiece findNearbyGarden(StructurePieceAccessor list, BoundingBox boundingBox) {
        BoundingBox largeBox = new BoundingBox(boundingBox.m_162395_() - 30, boundingBox.m_162396_() - 30, boundingBox.m_162398_() - 30, boundingBox.m_162399_() - 30, boundingBox.m_162400_() - 30, boundingBox.m_162401_() - 30);
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            for (StructurePiece component : start.f_192778_) {
                if (!(component instanceof TrollCaveGardenComponent) || !component.m_73547_().m_71049_(largeBox)) continue;
                return component;
            }
        }
        return null;
    }

    @Override
    protected boolean makeSmallerCave(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int caveSize, int caveHeight, Rotation rotation) {
        if (super.makeSmallerCave(list, rand, index, x, y, z, caveSize, caveHeight, rotation)) {
            this.openingTowards[rotation.ordinal()] = true;
            return true;
        }
        return false;
    }
}

