/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.client.particle.data.LeafParticleData;

public class SpawnFallenLeafFromPacket {
    private final BlockPos pos;
    private final Vec3 motion;

    public SpawnFallenLeafFromPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.motion = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public SpawnFallenLeafFromPacket(BlockPos pos, Vec3 motion) {
        this.pos = pos;
        this.motion = motion;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeDouble(this.motion.f_82479_);
        buf.writeDouble(this.motion.f_82480_);
        buf.writeDouble(this.motion.f_82481_);
    }

    public static class Handler {
        public static boolean onMessage(final SpawnFallenLeafFromPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Random rand = new Random();
                    ClientLevel world = Minecraft.m_91087_().f_91073_;
                    int color = Minecraft.m_91087_().m_91298_().m_92577_(Blocks.f_50050_.m_49966_(), (BlockAndTintGetter)world, message.pos, 0);
                    int r = Mth.m_14045_((int)((color >> 16 & 0xFF) + rand.nextInt(34) - 17), (int)0, (int)255);
                    int g = Mth.m_14045_((int)((color >> 8 & 0xFF) + rand.nextInt(34) - 17), (int)0, (int)255);
                    int b = Mth.m_14045_((int)((color & 0xFF) + rand.nextInt(34) - 17), (int)0, (int)255);
                    world.m_7106_((ParticleOptions)new LeafParticleData(r, g, b), (double)((float)message.pos.m_123341_() + world.m_213780_().m_188501_()), (double)message.pos.m_123342_(), (double)((float)message.pos.m_123343_() + world.m_213780_().m_188501_()), (double)(world.m_213780_().m_188501_() * -0.5f) * message.motion.m_7096_(), (double)(world.m_213780_().m_188501_() * 0.5f + 0.25f), (double)(world.m_213780_().m_188501_() * -0.5f) * message.motion.m_7094_());
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

