/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.boss.AlphaYeti;
import twilightforest.entity.projectile.IceBomb;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class YetiRampageGoal
extends Goal {
    private final AlphaYeti yeti;
    private int currentTimeOut;
    private int currentDuration;
    private final int maxTantrumTimeOut;
    private final int tantrumDuration;

    public YetiRampageGoal(AlphaYeti yeti, int timeout, int duration) {
        this.yeti = yeti;
        this.currentTimeOut = timeout;
        this.maxTantrumTimeOut = timeout;
        this.tantrumDuration = duration;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.yeti.m_5448_() != null && this.yeti.canRampage()) {
            --this.currentTimeOut;
        }
        return this.currentTimeOut <= 0;
    }

    public void m_8056_() {
        this.currentDuration = this.tantrumDuration;
        this.yeti.setRampaging(true);
        this.yeti.m_5496_((SoundEvent)TFSounds.ALPHA_YETI_ROAR.get(), 4.0f, 0.5f + this.yeti.m_217043_().m_188501_() * 0.5f);
        this.yeti.m_146850_(GameEvent.f_223709_);
    }

    public boolean m_8045_() {
        return this.currentDuration > 0;
    }

    public void m_8037_() {
        --this.currentDuration;
        if (this.yeti.m_5448_() != null) {
            this.yeti.m_21563_().m_24960_((Entity)this.yeti.m_5448_(), 10.0f, (float)this.yeti.m_8132_());
        }
        if (this.yeti.m_20096_()) {
            this.yeti.m_20334_(0.0, 0.4, 0.0);
            this.yeti.m_146850_(GameEvent.f_157770_);
        }
        this.yeti.destroyBlocksInAABB(this.yeti.m_20191_().m_82377_(1.0, 2.0, 1.0).m_82386_(0.0, 2.0, 0.0));
        if (this.currentDuration % 10 == 0) {
            this.yeti.makeRandomBlockFall(30, 80);
        }
        if (this.currentDuration % 20 == 0) {
            this.yeti.makeBlockAboveTargetFall();
        }
        if (this.currentDuration < 40 && this.currentDuration % 10 == 0) {
            this.yeti.makeRandomBlockFall(15, 40);
        }
        if (this.currentDuration % 20 == 0) {
            IceBomb ice = new IceBomb((EntityType<? extends IceBomb>)((EntityType)TFEntities.THROWN_ICE.get()), this.yeti.m_9236_(), (LivingEntity)this.yeti);
            Vec3 vec = new Vec3((double)(0.5f + this.yeti.m_217043_().m_188501_() * 0.5f), (double)(0.5f + this.yeti.m_217043_().m_188501_() * 0.3f), 0.0).m_82524_(this.yeti.m_217043_().m_188501_() * 360.0f);
            ice.m_6686_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 0.4f + this.yeti.m_217043_().m_188501_() * 0.3f, 0.0f);
            this.yeti.m_5496_((SoundEvent)TFSounds.ALPHA_YETI_ICE.get(), 1.0f, 1.0f / (this.yeti.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.yeti.m_146850_(GameEvent.f_157778_);
            this.yeti.m_9236_().m_7967_((Entity)ice);
        }
    }

    public void m_8041_() {
        this.currentTimeOut = this.maxTantrumTimeOut;
        this.yeti.setRampaging(false);
        this.yeti.setTired(true);
    }
}

