/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import twilightforest.entity.boss.Minoshroom;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;

public class GroundAttackGoal
extends Goal {
    private static final double MIN_RANGE_SQ = 2.0;
    private static final double MAX_RANGE_SQ = 9.0;
    private static final int FREQ = 24;
    private final Minoshroom attacker;
    private LivingEntity attackTarget;
    private int cooldown;
    private int attackTick;

    public GroundAttackGoal(Minoshroom minoshroom) {
        this.attacker = minoshroom;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.attackTarget = this.attacker.m_5448_();
        if (this.cooldown-- > 0 || this.attackTarget == null) {
            return false;
        }
        double distance = this.attacker.m_20280_((Entity)this.attackTarget);
        if (distance < 2.0 || distance > 9.0) {
            return false;
        }
        if (!this.attacker.m_20096_()) {
            return false;
        }
        if (this.attacker.m_142582_((Entity)this.attackTarget)) {
            return this.attacker.m_217043_().m_188503_(24) == 0;
        }
        return this.attacker.m_217043_().m_188503_(20) == 0;
    }

    public void m_8056_() {
        this.cooldown = 200 + this.attacker.m_217043_().m_188503_(200);
        this.attackTick = 30 + this.attacker.m_217043_().m_188503_(30);
        this.attacker.setMaxCharge(this.attackTick);
        this.attacker.setGroundAttackCharge(true);
    }

    public boolean m_8045_() {
        return this.attackTick >= 0;
    }

    public void m_8041_() {
        this.attackTick = 0;
        this.attackTarget = null;
    }

    public void m_8037_() {
        this.attacker.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
        this.attacker.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
        if (this.attackTick-- <= 0) {
            this.attacker.setGroundAttackCharge(false);
            this.attacker.m_5496_((SoundEvent)TFSounds.MINOSHROOM_SLAM.get(), 2.0f, 1.0f + this.attacker.m_217043_().m_188501_() * 0.1f);
            this.attacker.m_146850_(GameEvent.f_157770_);
            AABB selection = new AABB((double)((float)this.attacker.m_20183_().m_123341_() - 7.5f), (double)this.attacker.m_20183_().m_123342_(), (double)((float)this.attacker.m_20183_().m_123343_() - 7.5f), (double)((float)this.attacker.m_20183_().m_123341_() + 7.5f), (double)((float)this.attacker.m_20183_().m_123342_() + 3.0f), (double)((float)this.attacker.m_20183_().m_123343_() + 7.5f));
            List hit = this.attacker.m_9236_().m_6443_(Entity.class, selection, entity -> entity instanceof Player);
            for (Entity entity2 : hit) {
                if (!entity2.m_20096_()) continue;
                entity2.m_5997_(0.0, 0.23, 0.0);
                entity2.m_6469_(TFDamageTypes.getEntityDamageSource(this.attacker.m_9236_(), TFDamageTypes.SLAM, (Entity)this.attacker, new EntityType[0]), (float)(this.attacker.m_21133_(Attributes.f_22281_) * 0.5));
            }
        }
    }
}

