/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Objects;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.ClientAccessor;
import mcp.mobius.waila.access.DataWriter;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.gui.hud.TooltipPosition;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ComponentHandler {
    public static void requestBlockData(ClientAccessor accessor) {
        Registrar registrar = Registrar.get();
        Block block = accessor.getBlock();
        Object blockEntity = accessor.getBlockEntity();
        int rate = Waila.CONFIG.get().getGeneral().getRateLimit();
        if (blockEntity == null || !accessor.isTimeElapsed(rate) || !Waila.CONFIG.get().getGeneral().isDisplayTooltip()) {
            return;
        }
        if (registrar.blockData.get(block).isEmpty() && registrar.blockData.get(blockEntity).isEmpty()) {
            return;
        }
        accessor.resetTimer();
        accessor.setDataAccess(false);
        DataWriter.CLIENT.reset();
        Player player = accessor.getPlayer();
        for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : registrar.blockDataCtx.get(block)) {
            DataWriter.CLIENT.tryAppend(player, entry.instance(), accessor, PluginConfig.CLIENT, IBlockComponentProvider::appendDataContext);
        }
        for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : registrar.blockDataCtx.get(blockEntity)) {
            DataWriter.CLIENT.tryAppend(player, entry.instance(), accessor, PluginConfig.CLIENT, IBlockComponentProvider::appendDataContext);
        }
        DataWriter.CLIENT.send(PacketSender.c2s(), player);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130062_(accessor.getBlockHitResult());
        PacketSender.c2s().send(Packets.BLOCK, buf);
        accessor.setDataAccess(true);
    }

    public static void gatherBlock(ClientAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        Block block = accessor.getBlock();
        Object blockEntity = accessor.getBlockEntity();
        ComponentHandler.handleBlock(accessor, tooltip, block, position);
        if (blockEntity != null) {
            ComponentHandler.handleBlock(accessor, tooltip, blockEntity, position);
        }
    }

    private static void handleBlock(ClientAccessor accessor, Tooltip tooltip, Object obj, TooltipPosition position) {
        Registrar registrar = Registrar.get();
        List<IInstanceRegistry.Entry<IBlockComponentProvider>> providers = registrar.blockComponent.get((Object)position).get(obj);
        for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : providers) {
            IBlockComponentProvider provider = entry.instance();
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.CLIENT);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
        }
    }

    public static void requestEntityData(Entity entity, ClientAccessor accessor) {
        Registrar registrar = Registrar.get();
        Object trueEntity = accessor.getEntity();
        int rate = Waila.CONFIG.get().getGeneral().getRateLimit();
        if (trueEntity == null || !accessor.isTimeElapsed(rate)) {
            return;
        }
        if (registrar.entityData.get(trueEntity).isEmpty()) {
            return;
        }
        accessor.resetTimer();
        accessor.setDataAccess(false);
        DataWriter.CLIENT.reset();
        Player player = accessor.getPlayer();
        for (IInstanceRegistry.Entry<IEntityComponentProvider> entry : registrar.entityDataCtx.get(entity)) {
            DataWriter.CLIENT.tryAppend(player, entry.instance(), accessor, PluginConfig.CLIENT, IEntityComponentProvider::appendDataContext);
        }
        DataWriter.CLIENT.send(PacketSender.c2s(), player);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(entity.m_19879_());
        Vec3 hitPos = accessor.getEntityHitResult().m_82450_();
        buf.writeDouble(hitPos.f_82479_);
        buf.writeDouble(hitPos.f_82480_);
        buf.writeDouble(hitPos.f_82481_);
        PacketSender.c2s().send(Packets.ENTITY, buf);
        accessor.setDataAccess(true);
    }

    public static void gatherEntity(Entity entity, ClientAccessor accessor, Tooltip tooltip, TooltipPosition position) {
        Registrar registrar = Registrar.get();
        List<IInstanceRegistry.Entry<IEntityComponentProvider>> providers = registrar.entityComponent.get((Object)position).get(entity);
        for (IInstanceRegistry.Entry<IEntityComponentProvider> entry : providers) {
            IEntityComponentProvider provider = entry.instance();
            try {
                switch (position) {
                    case HEAD: {
                        provider.appendHead(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case BODY: {
                        provider.appendBody(tooltip, accessor, PluginConfig.CLIENT);
                        break;
                    }
                    case TAIL: {
                        provider.appendTail(tooltip, accessor, PluginConfig.CLIENT);
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.dump(e, provider.getClass().toString(), tooltip);
            }
        }
    }

    public static ITooltipComponent getIcon(HitResult target) {
        Registrar registrar = Registrar.get();
        ClientAccessor data = ClientAccessor.INSTANCE;
        PluginConfig config = PluginConfig.CLIENT;
        if (target.m_6662_() == HitResult.Type.ENTITY) {
            List<IInstanceRegistry.Entry<IEntityComponentProvider>> providers = registrar.entityIcon.get(data.getEntity());
            for (IInstanceRegistry.Entry<IEntityComponentProvider> provider : providers) {
                ITooltipComponent icon = provider.instance().getIcon(data, config);
                if (icon == null) continue;
                return icon;
            }
        } else {
            Object blockEntity;
            BlockState state = data.getBlockState();
            if (state.m_60795_()) {
                return EmptyComponent.INSTANCE;
            }
            ITooltipComponent result = null;
            int priority = 0;
            for (IInstanceRegistry.Entry<IBlockComponentProvider> provider : registrar.blockIcon.get(state.m_60734_())) {
                ITooltipComponent icon = provider.instance().getIcon(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
                if (icon == null) continue;
                result = icon;
                priority = provider.priority();
                break;
            }
            if ((blockEntity = data.getBlockEntity()) != null) {
                for (IInstanceRegistry.Entry<IBlockComponentProvider> provider : registrar.blockIcon.get(blockEntity)) {
                    if (provider.priority() >= priority) break;
                    ITooltipComponent icon = provider.instance().getIcon(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
                    if (icon == null) continue;
                    result = icon;
                    break;
                }
            }
            if (result != null) {
                return result;
            }
        }
        return EmptyComponent.INSTANCE;
    }

    @Nullable
    public static Entity getOverrideEntity(HitResult target) {
        if (target == null || target.m_6662_() != HitResult.Type.ENTITY) {
            return null;
        }
        Registrar registrar = Registrar.get();
        Entity entity = ((EntityHitResult)target).m_82443_();
        List<IInstanceRegistry.Entry<IEntityComponentProvider>> overrideProviders = registrar.entityOverride.get(entity);
        for (IInstanceRegistry.Entry<IEntityComponentProvider> provider : overrideProviders) {
            Entity override = provider.instance().getOverride(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            if (override == null) continue;
            return override;
        }
        return entity;
    }

    public static BlockState getOverrideBlock(HitResult target) {
        Registrar registrar = Registrar.get();
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        BlockPos pos = ((BlockHitResult)target).m_82425_();
        BlockState state = world.m_8055_(pos);
        BlockState override = null;
        int priority = 0;
        List<IInstanceRegistry.Entry<IBlockComponentProvider>> providers = registrar.blockOverride.get(state.m_60734_());
        for (IInstanceRegistry.Entry<IBlockComponentProvider> provider : providers) {
            BlockState blockOverride = provider.instance().getOverride(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            if (blockOverride == null) continue;
            override = blockOverride;
            priority = provider.priority();
            break;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        providers = registrar.blockOverride.get(blockEntity);
        for (IInstanceRegistry.Entry<IBlockComponentProvider> provider : providers) {
            if (provider.priority() >= priority) break;
            BlockState beOverride = provider.instance().getOverride(ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            if (beOverride == null) continue;
            override = beOverride;
            break;
        }
        return override != null ? override : state;
    }
}

