/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Galaxy;
import net.povstalec.sgjourney.common.stargate.SolarSystem;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.Wormhole;

public final class StargateConnection {
    private static final String EVENT_CHEVRON_ENGAGED = "stargate_chevron_engaged";
    private static final String EVENT_INCOMING_CONNECTION = "stargate_incoming_connection";
    private static final String EVENT_INCOMING_WORMHOLE = "stargate_incoming_wormhole";
    private static final String EVENT_OUTGOING_WORMHOLE = "stargate_outgoing_wormhole";
    private static final String EVENT_DISCONNECTED = "stargate_disconnected";
    private static final String DIMENSION = "Dimension";
    private static final String COORDINATES = "Coordinates";
    private static final String DIALING_STARGATE = "DialingStargate";
    private static final String DIALED_STARGATE = "DialedStargate";
    private static final String USED = "Used";
    private static final String TIME_SINCE_LAST_TRAVELER = "TimeSinceLastTraveler";
    private static final String OPEN_TIME = "OpenTime";
    private static final String CONNECTION_TIME = "ConnectionTime";
    private static final String CONNECTION_TYPE = "ConnectionType";
    private static final String DO_KAWOOSH = "DoKawoosh";
    public static final int KAWOOSH_TICKS = 40;
    public static final int VORTEX_TICKS = 20;
    protected static final int maxOpenTime = (Integer)CommonStargateConfig.max_wormhole_open_time.get() * 20;
    protected static final boolean energyBypassEnabled = (Boolean)CommonStargateConfig.enable_energy_bypass.get();
    protected static final int energyBypassMultiplier = (Integer)CommonStargateConfig.energy_bypass_multiplier.get();
    protected static final boolean requireEnergy = !StargateJourneyConfig.disable_energy_use.get();
    protected static final long systemWideConnectionCost = (Long)CommonStargateConfig.system_wide_connection_energy_cost.get();
    protected static final long interstellarConnectionCost = (Long)CommonStargateConfig.interstellar_connection_energy_cost.get();
    protected static final long intergalacticConnectionCost = (Long)CommonStargateConfig.intergalactic_connection_energy_cost.get();
    protected static final long systemWideConnectionDraw = (Long)CommonStargateConfig.system_wide_connection_energy_draw.get();
    protected static final long interstellarConnectionDraw = (Long)CommonStargateConfig.interstellar_connection_energy_draw.get();
    protected static final long intergalacticConnectionDraw = (Long)CommonStargateConfig.intergalactic_connection_energy_draw.get();
    protected final String uuid;
    protected final Type connectionType;
    protected final AbstractStargateEntity dialingStargate;
    protected AbstractStargateEntity dialedStargate;
    protected boolean doKawoosh;
    protected boolean used = false;
    protected int openTime = 0;
    protected int connectionTime = 0;
    protected int timeSinceLastTraveler = 0;

    private StargateConnection(String uuid, Type connectionType, AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate, boolean used, int openTime, int connectionTime, int timeSinceLastTraveler, boolean doKawoosh) {
        this.uuid = uuid;
        this.connectionType = connectionType;
        this.dialingStargate = dialingStargate;
        this.dialedStargate = dialedStargate;
        this.used = used;
        this.openTime = openTime;
        this.connectionTime = connectionTime;
        this.timeSinceLastTraveler = timeSinceLastTraveler;
        this.doKawoosh = doKawoosh;
    }

    public final void printConnection() {
        System.out.println("-[" + this.uuid + "]");
        System.out.println(" | From: " + this.dialingStargate.get9ChevronAddress().toString());
        System.out.println(" | To: " + this.dialedStargate.get9ChevronAddress().toString());
        System.out.println(" | Open Time: " + this.openTime);
        System.out.println(" | Connection Time: " + this.connectionTime);
    }

    public static final Type getType(MinecraftServer server, Stargate dialingStargate, Stargate dialedStargate) {
        Optional<SolarSystem.Serializable> dialingSystemOptional = Universe.get(server).getSolarSystemFromDimension(dialingStargate.getDimension());
        Optional<SolarSystem.Serializable> dialedSystemOptional = Universe.get(server).getSolarSystemFromDimension(dialedStargate.getDimension());
        if (dialingSystemOptional.isPresent() && dialedSystemOptional.isPresent()) {
            SolarSystem.Serializable dialedSystem;
            SolarSystem.Serializable dialingSystem = dialingSystemOptional.get();
            if (dialingSystem.equals(dialedSystem = dialedSystemOptional.get())) {
                return Type.SYSTEM_WIDE;
            }
            List dialingGalaxies = dialingSystem.getGalacticAddresses().entrySet().stream().toList();
            List dialedGalaxies = dialedSystem.getGalacticAddresses().entrySet().stream().toList();
            if (!dialingGalaxies.isEmpty() && !dialedGalaxies.isEmpty()) {
                for (int i = 0; i < dialingGalaxies.size(); ++i) {
                    for (int j = 0; j < dialedGalaxies.size(); ++j) {
                        Galaxy.Serializable dialedGalaxy;
                        Galaxy.Serializable dialingGalaxy = (Galaxy.Serializable)((Map.Entry)dialingGalaxies.get(i)).getKey();
                        if (!dialingGalaxy.equals(dialedGalaxy = (Galaxy.Serializable)((Map.Entry)dialedGalaxies.get(j)).getKey())) continue;
                        return Type.INTERSTELLAR;
                    }
                }
            }
        }
        return Type.INTERGALACTIC;
    }

    private StargateConnection(String uuid, Type connectionType, AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate, boolean doKawoosh) {
        this(uuid, connectionType, dialingStargate, dialedStargate, false, 0, 0, 0, doKawoosh);
    }

    public static final StargateConnection create(Type connectionType, AbstractStargateEntity dialingStargate, AbstractStargateEntity dialedStargate, boolean doKawoosh) {
        String uuid = UUID.randomUUID().toString();
        if (dialingStargate != null && dialedStargate != null) {
            dialedStargate.resetStargate(Stargate.Feedback.INTERRUPTED_BY_INCOMING_CONNECTION);
            dialingStargate.setKawooshTickCount(0);
            dialingStargate.updateClient();
            dialedStargate.setKawooshTickCount(0);
            dialedStargate.updateClient();
            dialingStargate.connectStargate(uuid, State.OUTGOING_CONNECTION);
            dialedStargate.connectStargate(uuid, State.INCOMING_CONNECTION);
            return new StargateConnection(uuid, connectionType, dialingStargate, dialedStargate, doKawoosh);
        }
        return null;
    }

    public final void terminate(MinecraftServer server, Stargate.Feedback feedback) {
        if (this.dialingStargate != null) {
            this.dialingStargate.updateInterfaceBlocks(EVENT_DISCONNECTED, feedback.getCode());
            this.dialingStargate.resetStargate(feedback);
        }
        if (this.dialedStargate != null) {
            this.dialedStargate.updateInterfaceBlocks(EVENT_DISCONNECTED, feedback.getCode());
            this.dialedStargate.resetStargate(feedback);
        }
        StargateNetwork.get(server).removeConnection(this.uuid, feedback);
    }

    public final boolean isStargateValid(AbstractStargateEntity stargate) {
        if (stargate == null) {
            StargateJourney.LOGGER.error("Stargate does not exist");
            return false;
        }
        BlockPos stargatePos = stargate.m_58899_();
        Level stargateLevel = stargate.m_58904_();
        if (stargateLevel.m_7702_(stargatePos) instanceof AbstractStargateEntity) {
            if (stargate.isConnected()) {
                return true;
            }
            StargateJourney.LOGGER.info("Stargate is not connected");
            return false;
        }
        StargateJourney.LOGGER.info("Stargate not found");
        return false;
    }

    public final void tick(MinecraftServer server) {
        if (!this.isStargateValid(this.dialingStargate) || !this.isStargateValid(this.dialedStargate)) {
            this.terminate(server, Stargate.Feedback.COULD_NOT_REACH_TARGET_STARGATE);
            return;
        }
        if (this.openTime == 0) {
            this.dialedStargate.updateInterfaceBlocks(EVENT_INCOMING_CONNECTION, new Object[0]);
        }
        Stargate.ChevronLockSpeed chevronLockSpeed = !this.doKawoosh() ? Stargate.ChevronLockSpeed.FAST : this.dialedStargate.getChevronLockSpeed();
        int chevronWaitTicks = chevronLockSpeed.getChevronWaitTicks();
        int kawooshStartTicks = chevronLockSpeed.getKawooshStartTicks();
        int maxKawooshTicks = kawooshStartTicks + 40;
        int maxOpenTicks = maxKawooshTicks + 20;
        this.increaseTicks(kawooshStartTicks, maxKawooshTicks, maxOpenTicks);
        int realOpenTime = this.openTime - kawooshStartTicks;
        if (this.openTime <= kawooshStartTicks) {
            if (this.doKawoosh()) {
                this.playStargateOpenSound(this.dialingStargate, kawooshStartTicks, this.openTime, false);
                this.playStargateOpenSound(this.dialedStargate, kawooshStartTicks, this.openTime, true);
            }
            int addressLength = this.dialingStargate.getAddress().getLength();
            Address dialingAddress = this.dialingStargate.getConnectionAddress(addressLength);
            this.dialedStargate.setEngagedChevrons(AbstractStargateEntity.getChevronConfiguration(addressLength));
            this.dialedStargate.doWhileDialed(this.openTime, chevronLockSpeed);
            if (this.openTime % chevronWaitTicks == 0) {
                int dialedAddressLength = this.dialedStargate.getAddress().getLength();
                if (dialedAddressLength < dialingAddress.getLength()) {
                    if (this.openTime / chevronWaitTicks == 4 && addressLength < 7) {
                        return;
                    }
                    if (this.openTime / chevronWaitTicks == 5 && addressLength < 8) {
                        return;
                    }
                    this.dialedStargate.encodeChevron(dialingAddress.getSymbol(dialedAddressLength), true, false);
                } else {
                    this.dialedStargate.chevronSound((short)0, true, false, false);
                    this.dialedStargate.updateInterfaceBlocks(EVENT_CHEVRON_ENGAGED, this.dialedStargate.getAddress().getLength() + 1, AbstractStargateEntity.getChevron(this.dialedStargate, this.dialedStargate.getAddress().getLength() + 1), true, 0);
                }
            }
            if (this.openTime == kawooshStartTicks) {
                List<Integer> emptyAddressList = Arrays.stream(new int[0]).boxed().toList();
                List<Integer> dialedAddressList = Arrays.stream(this.dialedStargate.getAddress().toArray()).boxed().toList();
                this.dialedStargate.updateBasicInterfaceBlocks(EVENT_INCOMING_WORMHOLE, emptyAddressList);
                this.dialedStargate.updateCrystalInterfaceBlocks(EVENT_INCOMING_WORMHOLE, emptyAddressList);
                this.dialedStargate.updateAdvancedCrystalInterfaceBlocks(EVENT_INCOMING_WORMHOLE, dialedAddressList);
                List<Integer> dialingAddressList = Arrays.stream(this.dialingStargate.getAddress().toArray()).boxed().toList();
                this.dialingStargate.updateInterfaceBlocks(EVENT_OUTGOING_WORMHOLE, dialingAddressList);
            }
            return;
        }
        if (this.openTime < maxOpenTicks) {
            this.dialingStargate.doKawoosh(realOpenTime);
            this.dialedStargate.doKawoosh(realOpenTime);
        } else {
            this.dialingStargate.setKawooshTickCount(realOpenTime);
            this.dialingStargate.updateClient();
            this.dialedStargate.setKawooshTickCount(realOpenTime);
            this.dialedStargate.updateClient();
        }
        if (this.doKawoosh() && this.openTime < maxKawooshTicks) {
            return;
        }
        this.dialingStargate.idleWormholeSound(false);
        this.dialedStargate.idleWormholeSound(true);
        if (this.connectionTime >= maxOpenTime && !energyBypassEnabled) {
            this.terminate(server, Stargate.Feedback.EXCEEDED_CONNECTION_TIME);
            return;
        }
        if (requireEnergy) {
            long energyDraw = this.connectionType.getPowerDraw();
            long l = energyDraw = this.connectionTime >= maxOpenTime ? energyDraw * (long)energyBypassMultiplier : energyDraw;
            if (!this.dialingStargate.canExtractEnergy(energyDraw) && !this.dialedStargate.canExtractEnergy(energyDraw)) {
                this.terminate(server, Stargate.Feedback.RAN_OUT_OF_POWER);
                return;
            }
            if (this.dialedStargate.getEnergyStored() > this.dialingStargate.getEnergyStored()) {
                this.dialedStargate.depleteEnergy(energyDraw, false);
            } else {
                this.dialingStargate.depleteEnergy(energyDraw, false);
            }
        }
        if (this.used) {
            ++this.timeSinceLastTraveler;
        }
        this.doWormhole(this.dialingStargate.getWormhole(), this.dialingStargate, this.dialedStargate, Stargate.WormholeTravel.ENABLED);
        this.doWormhole(this.dialedStargate.getWormhole(), this.dialedStargate, this.dialingStargate, (Stargate.WormholeTravel)((Object)CommonStargateConfig.two_way_wormholes.get()));
        if (this.dialingStargate.autoclose() > 0 && this.timeSinceLastTraveler >= this.dialingStargate.autoclose() * 20) {
            this.terminate(server, Stargate.Feedback.CONNECTION_ENDED_BY_AUTOCLOSE);
        }
        if (this.dialedStargate.autoclose() > 0 && this.timeSinceLastTraveler >= this.dialedStargate.autoclose() * 20) {
            this.terminate(server, Stargate.Feedback.CONNECTION_ENDED_BY_AUTOCLOSE);
        }
    }

    private final void playStargateOpenSound(AbstractStargateEntity stargate, int kawooshStartTicks, int ticks, boolean incoming) {
        if (ticks == kawooshStartTicks - stargate.getOpenSoundLead()) {
            stargate.openWormholeSound(incoming);
        }
    }

    private final void increaseTicks(int kawooshStartTicks, int maxKawooshTicks, int maxOpenTicks) {
        if (!this.doKawoosh() && this.openTime >= kawooshStartTicks && this.openTime < maxKawooshTicks) {
            this.openTime += 60;
        } else if (this.openTime < maxOpenTicks) {
            ++this.openTime;
        }
        if (this.openTime > maxKawooshTicks) {
            ++this.connectionTime;
        }
    }

    private final void doWormhole(Wormhole wormhole, AbstractStargateEntity initialStargate, AbstractStargateEntity targetStargate, Stargate.WormholeTravel wormholeTravel) {
        if (initialStargate.isIrisClosed()) {
            return;
        }
        Vec3 stargatePos = initialStargate.getCenter();
        if (wormhole.findCandidates(initialStargate.m_58904_(), stargatePos, initialStargate.getDirection()) && this.used) {
            this.timeSinceLastTraveler = 0;
        }
        if (targetStargate.shouldCallForward()) {
            if (wormhole.wormholeEntities(initialStargate, initialStargate, wormholeTravel)) {
                this.used = true;
            }
        } else if (wormhole.wormholeEntities(initialStargate, targetStargate, wormholeTravel)) {
            this.used = true;
        }
    }

    public void sendStargateMessage(AbstractStargateEntity sendingStargate, String message) {
        if (sendingStargate.get9ChevronAddress().equals(this.dialingStargate.get9ChevronAddress())) {
            this.dialedStargate.receiveStargateMessage(message);
        } else {
            this.dialingStargate.receiveStargateMessage(message);
        }
    }

    public void sendStargateTransmission(AbstractStargateEntity sendingStargate, int transmissionJumps, int frequency, String transmission) {
        if (sendingStargate.get9ChevronAddress().equals(this.dialingStargate.get9ChevronAddress())) {
            this.dialedStargate.forwardTransmission(transmissionJumps, frequency, transmission);
        } else {
            this.dialingStargate.forwardTransmission(transmissionJumps, frequency, transmission);
        }
    }

    public float checkStargateShieldingState(AbstractStargateEntity sendingStargate) {
        if (sendingStargate.get9ChevronAddress().equals(this.dialingStargate.get9ChevronAddress())) {
            return this.dialedStargate.checkIrisState();
        }
        return this.dialingStargate.checkIrisState();
    }

    public String getID() {
        return this.uuid;
    }

    public int getOpenTime() {
        return this.openTime;
    }

    public int getConnectionTime() {
        return this.connectionTime;
    }

    public int getTimeSinceLastTraveler() {
        return this.timeSinceLastTraveler;
    }

    public boolean doKawoosh() {
        return this.doKawoosh;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(DIALING_STARGATE, (Tag)this.serializeStargate(this.dialingStargate));
        tag.m_128365_(DIALED_STARGATE, (Tag)this.serializeStargate(this.dialedStargate));
        tag.m_128379_(USED, this.used);
        tag.m_128405_(OPEN_TIME, this.openTime);
        tag.m_128405_(CONNECTION_TIME, this.connectionTime);
        tag.m_128405_(TIME_SINCE_LAST_TRAVELER, this.timeSinceLastTraveler);
        tag.m_128359_(CONNECTION_TYPE, this.connectionType.toString().toUpperCase());
        tag.m_128379_(DO_KAWOOSH, this.doKawoosh);
        return tag;
    }

    protected CompoundTag serializeStargate(AbstractStargateEntity stargate) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(DIMENSION, stargate.m_58904_().m_46472_().m_135782_().toString());
        tag.m_128385_(COORDINATES, new int[]{stargate.m_58899_().m_123341_(), stargate.m_58899_().m_123342_(), stargate.m_58899_().m_123343_()});
        return tag;
    }

    public static StargateConnection deserialize(MinecraftServer server, String uuid, CompoundTag tag) {
        Type connectionType = Type.valueOf(tag.m_128461_(CONNECTION_TYPE));
        AbstractStargateEntity dialingStargate = StargateConnection.deserializeStargate(server, tag.m_128469_(DIALING_STARGATE));
        AbstractStargateEntity dialedStargate = StargateConnection.deserializeStargate(server, tag.m_128469_(DIALED_STARGATE));
        boolean used = tag.m_128471_(USED);
        int openTime = tag.m_128451_(OPEN_TIME);
        int connectionTime = tag.m_128451_(CONNECTION_TIME);
        int timeSinceLastTraveler = tag.m_128451_(TIME_SINCE_LAST_TRAVELER);
        boolean doKawoosh = tag.m_128471_(DO_KAWOOSH);
        return new StargateConnection(uuid, connectionType, dialingStargate, dialedStargate, used, openTime, connectionTime, timeSinceLastTraveler, doKawoosh);
    }

    protected static AbstractStargateEntity deserializeStargate(MinecraftServer server, CompoundTag stargateInfo) {
        ResourceKey<Level> dimension = Conversion.stringToDimension(stargateInfo.m_128461_(DIMENSION));
        BlockPos pos = Conversion.intArrayToBlockPos(stargateInfo.m_128465_(COORDINATES));
        BlockEntity blockEntity = server.m_129880_(dimension).m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return stargate;
        }
        return null;
    }

    public static enum Type {
        SYSTEM_WIDE(systemWideConnectionCost, systemWideConnectionDraw),
        INTERSTELLAR(interstellarConnectionCost, interstellarConnectionDraw),
        INTERGALACTIC(intergalacticConnectionCost, intergalacticConnectionDraw);

        private long establishingPowerCost;
        private long powerDraw;

        private Type(long establishingPowerCost, long powerDraw) {
            this.establishingPowerCost = establishingPowerCost;
            this.powerDraw = powerDraw;
        }

        public long getEstablishingPowerCost() {
            return this.establishingPowerCost;
        }

        public long getPowerDraw() {
            return this.powerDraw;
        }
    }

    public static enum State implements StringRepresentable
    {
        IDLE("idle", false, false),
        OUTGOING_CONNECTION("outgoing_connection", true, true),
        INCOMING_CONNECTION("incoming_connection", true, false);

        private final String name;
        private final boolean isConnected;
        private final boolean isDialingOut;

        private State(String name, boolean isConnected, boolean isDialingOut) {
            this.name = name;
            this.isConnected = isConnected;
            this.isDialingOut = isDialingOut;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public boolean isDialingOut() {
            return this.isDialingOut;
        }
    }
}

