/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.events.custom.SGJourneyEvents;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.SolarSystem;
import net.povstalec.sgjourney.common.stargate.Stargate;

public class Dialing {
    public static final int[] DIALED_7_CHEVRON_CONFIGURATION = new int[]{1, 2, 3, 6, 7, 8, 4, 5};
    public static final int[] DIALED_8_CHEVRON_CONFIGURATION = new int[]{1, 2, 3, 4, 6, 7, 8, 5};
    public static final int[] DIALED_9_CHEVRON_CONFIGURATION = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    public static final int[] DEFAULT_CHEVRON_CONFIGURATION = DIALED_7_CHEVRON_CONFIGURATION;

    public static Stargate.Feedback dialStargate(ServerLevel level, Stargate dialingStargate, Address.Immutable address, Address.Immutable dialingAddress, boolean doKawoosh) {
        if (SGJourneyEvents.onStargateDial(level.m_7654_(), dialingStargate, address, dialingAddress, doKawoosh)) {
            return Stargate.Feedback.NONE;
        }
        switch (address.getLength()) {
            case 6: {
                return Dialing.get7ChevronStargate(level, dialingStargate, address, dialingAddress, doKawoosh);
            }
            case 7: {
                return Dialing.get8ChevronStargate(level, dialingStargate, address, dialingAddress, doKawoosh);
            }
            case 8: {
                return Dialing.get9ChevronStargate(level, dialingStargate, address, dialingAddress, doKawoosh);
            }
        }
        return dialingStargate.resetStargate(level.m_7654_(), Stargate.Feedback.INVALID_ADDRESS);
    }

    private static Stargate.Feedback get7ChevronStargate(ServerLevel level, Stargate dialingStargate, Address.Immutable dialedAddress, Address.Immutable dialingAddress, boolean doKawoosh) {
        Optional<SolarSystem.Serializable> solarSystem = Universe.get((Level)level).getSolarSystemFromAddress((ResourceKey<Level>)level.m_46472_(), dialedAddress);
        if (solarSystem.isEmpty()) {
            return dialingStargate.resetStargate(level.m_7654_(), Stargate.Feedback.INVALID_ADDRESS);
        }
        return Dialing.getStargate(level, dialingStargate, solarSystem.get(), Address.Type.ADDRESS_7_CHEVRON, dialingAddress, doKawoosh);
    }

    private static Stargate.Feedback get8ChevronStargate(ServerLevel level, Stargate dialingStargate, Address.Immutable extragalacticAddress, Address.Immutable dialingAddress, boolean doKawoosh) {
        Optional<SolarSystem.Serializable> solarSystem = Universe.get((Level)level).getSolarSystemFromExtragalacticAddress(extragalacticAddress);
        if (solarSystem.isEmpty()) {
            return dialingStargate.resetStargate(level.m_7654_(), Stargate.Feedback.INVALID_ADDRESS);
        }
        return Dialing.getStargate(level, dialingStargate, solarSystem.get(), Address.Type.ADDRESS_8_CHEVRON, dialingAddress, doKawoosh);
    }

    private static Stargate.Feedback getStargate(ServerLevel level, Stargate dialingStargate, SolarSystem.Serializable dialedSystem, Address.Type addressType, Address.Immutable dialingAddress, boolean doKawoosh) {
        Optional<SolarSystem.Serializable> currentSystem = Universe.get((Level)level).getSolarSystemFromDimension((ResourceKey<Level>)level.m_46472_());
        MinecraftServer server = level.m_7654_();
        if (currentSystem.isPresent() && dialedSystem.equals(currentSystem.get())) {
            return dialingStargate.resetStargate(server, Stargate.Feedback.SAME_SYSTEM_DIAL);
        }
        if (dialedSystem.getStargates().isEmpty()) {
            List<ResourceKey<Level>> dimensionList = dialedSystem.getDimensions();
            int dimensions = 0;
            for (int i = 0; i < dimensionList.size(); ++i) {
                ResourceKey<Level> levelKey = dimensionList.get(i);
                if (!level.m_7654_().m_129784_().contains(levelKey)) continue;
                ServerLevel targetLevel = server.m_129880_(levelKey);
                StargateNetwork.findStargates(targetLevel);
                ++dimensions;
            }
            if (dimensions == 0) {
                return dialingStargate.resetStargate(server, Stargate.Feedback.NO_DIMENSIONS);
            }
        }
        return Dialing.getPreferredStargate(level, dialingStargate, dialedSystem, addressType, dialingAddress, doKawoosh);
    }

    private static Stargate.Feedback getStargateFromAddress(MinecraftServer server, Stargate dialingStargate, Address.Immutable address, Address.Immutable dialingAddress, boolean doKawoosh) {
        BlockEntity blockEntity;
        Optional<Stargate> stargate = StargateNetwork.get(server).getStargate(address);
        if (stargate.isEmpty()) {
            return dialingStargate.resetStargate(server, Stargate.Feedback.INVALID_ADDRESS);
        }
        BlockPos pos = stargate.get().getBlockPos();
        ResourceKey<Level> dimension = stargate.get().getDimension();
        if (pos != null && dimension != null && (blockEntity = server.m_129880_(dimension).m_7702_(pos)) instanceof AbstractStargateEntity) {
            AbstractStargateEntity targetStargate = (AbstractStargateEntity)blockEntity;
            if (targetStargate.isObstructed()) {
                return dialingStargate.resetStargate(server, Stargate.Feedback.TARGET_OBSTRUCTED);
            }
            if (targetStargate.getFilterType().shouldFilter()) {
                if (targetStargate.getFilterType().isBlacklist() && targetStargate.isAddressBlacklisted(dialingAddress)) {
                    return dialingStargate.resetStargate(server, Stargate.Feedback.BLACKLISTED_SELF);
                }
                if (targetStargate.getFilterType().isWhitelist() && !targetStargate.isAddressWhitelisted(dialingAddress)) {
                    return dialingStargate.resetStargate(server, Stargate.Feedback.WHITELISTED_SELF);
                }
            }
            return Dialing.connectStargates(server, dialingStargate, stargate.get(), Address.Type.ADDRESS_9_CHEVRON, doKawoosh);
        }
        return dialingStargate.resetStargate(server, Stargate.Feedback.COULD_NOT_REACH_TARGET_STARGATE);
    }

    private static Stargate.Feedback get9ChevronStargate(ServerLevel level, Stargate dialingStargate, Address.Immutable address, Address.Immutable dialingAddress, boolean doKawoosh) {
        return Dialing.getStargateFromAddress(level.m_7654_(), dialingStargate, address, dialingAddress, doKawoosh);
    }

    private static Stargate.Feedback getPreferredStargate(ServerLevel level, Stargate dialingStargate, SolarSystem.Serializable solarSystem, Address.Type addressType, Address.Immutable dialingAddress, boolean doKawoosh) {
        MinecraftServer server = level.m_7654_();
        List<Stargate> stargates = solarSystem.getStargates();
        if (stargates.isEmpty()) {
            return dialingStargate.resetStargate(server, Stargate.Feedback.NO_STARGATES);
        }
        for (int i = 0; i < stargates.size(); ++i) {
            boolean isLastStargate = i == stargates.size() - 1;
            Stargate targetStargate = stargates.get(i);
            BlockEntity blockEntity = server.m_129880_(targetStargate.getDimension()).m_7702_(targetStargate.getBlockPos());
            if (!(blockEntity instanceof AbstractStargateEntity)) continue;
            AbstractStargateEntity targetStargateEntity = (AbstractStargateEntity)blockEntity;
            if (!(targetStargateEntity.isObstructed() || targetStargateEntity.isRestricted(dialingStargate.getNetwork()) || targetStargateEntity.getFilterType().isBlacklist() && targetStargateEntity.isAddressBlacklisted(dialingAddress) || targetStargateEntity.getFilterType().isWhitelist() && !targetStargateEntity.isAddressWhitelisted(dialingAddress))) {
                return Dialing.connectStargates(level.m_7654_(), dialingStargate, targetStargate, addressType, doKawoosh);
            }
            if (targetStargateEntity.isObstructed() && isLastStargate) {
                return dialingStargate.resetStargate(server, Stargate.Feedback.TARGET_OBSTRUCTED);
            }
            if (targetStargateEntity.isRestricted(dialingStargate.getNetwork()) && isLastStargate) {
                return dialingStargate.resetStargate(server, Stargate.Feedback.TARGET_RESTRICTED);
            }
            if (targetStargateEntity.getFilterType().isBlacklist() && targetStargateEntity.isAddressBlacklisted(dialingAddress) && isLastStargate) {
                return dialingStargate.resetStargate(server, Stargate.Feedback.BLACKLISTED_SELF);
            }
            if (!targetStargateEntity.getFilterType().isWhitelist() || targetStargateEntity.isAddressWhitelisted(dialingAddress) || !isLastStargate) continue;
            return dialingStargate.resetStargate(server, Stargate.Feedback.WHITELISTED_SELF);
        }
        return dialingStargate.resetStargate(server, Stargate.Feedback.UNKNOWN_ERROR);
    }

    public static Stargate.Feedback connectStargates(MinecraftServer server, Stargate dialingStargate, Stargate dialedStargate, Address.Type addressType, boolean doKawoosh) {
        return StargateNetwork.get(server).createConnection(server, dialingStargate, dialedStargate, addressType, doKawoosh);
    }
}

