/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.StargateNetworkSettings;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Galaxy;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.SolarSystem;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.Symbols;

public class Universe
extends SavedData {
    private static final ResourceLocation MILKY_WAY = new ResourceLocation("sgjourney", "milky_way");
    private static final String FILE_NAME = "sgjourney-universe";
    private static final String DIMENSIONS = "Dimensions";
    private static final String SOLAR_SYSTEMS = "SolarSystems";
    private static final String GALAXIES = "Galaxies";
    private static final String NUMBERS_AND_LETTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private MinecraftServer server;
    private HashMap<Address.Immutable, SolarSystem.Serializable> solarSystems = new HashMap();
    private HashMap<ResourceKey<Level>, SolarSystem.Serializable> dimensions = new HashMap();
    private HashMap<String, Galaxy.Serializable> galaxies = new HashMap();

    public void generateUniverseInfo(MinecraftServer server) {
        this.registerGalaxies(server);
        this.registerPointsOfOrigin(server);
        this.registerSolarSystemsFromDataPacks(server);
        if (this.generateRandomSolarSystems(server)) {
            this.generateAndRegisterSolarSystems(server);
        }
        this.m_77762_();
    }

    public void eraseUniverseInfo() {
        this.galaxies.clear();
        this.dimensions.clear();
        this.solarSystems.clear();
        this.m_77762_();
    }

    private boolean useDatapackAddresses(MinecraftServer server) {
        return StargateNetworkSettings.get(server).useDatapackAddresses();
    }

    private boolean generateRandomSolarSystems(MinecraftServer server) {
        return StargateNetworkSettings.get(server).generateRandomSolarSystems();
    }

    private boolean randomAddressFromSeed(MinecraftServer server) {
        return StargateNetworkSettings.get(server).randomAddressFromSeed();
    }

    private void registerGalaxies(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry galaxyRegistry = registries.m_175515_(Galaxy.REGISTRY_KEY);
        Set galaxySet = galaxyRegistry.m_6579_();
        galaxySet.forEach(galaxyEntry -> {
            ResourceKey galaxyKey = (ResourceKey)galaxyEntry.getKey();
            Galaxy.Serializable galaxy = new Galaxy.Serializable((ResourceKey<Galaxy>)galaxyKey, (Galaxy)galaxyEntry.getValue(), new HashMap<Address.Immutable, SolarSystem.Serializable>(), new ArrayList<ResourceKey<PointOfOrigin>>());
            this.galaxies.put(((ResourceKey)galaxyEntry.getKey()).m_135782_().toString(), galaxy);
        });
        StargateJourney.LOGGER.info("Galaxies registered");
    }

    private void registerPointsOfOrigin(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
        Set pointOfOriginSet = pointOfOriginRegistry.m_6579_();
        pointOfOriginSet.forEach(pointOfOriginEntry -> {
            PointOfOrigin pointOfOrigin = (PointOfOrigin)pointOfOriginEntry.getValue();
            ResourceKey pointOfOriginKey = (ResourceKey)pointOfOriginEntry.getKey();
            Optional<List<ResourceKey<Galaxy>>> galaxiesOptional = pointOfOrigin.generatedGalaxies();
            if (galaxiesOptional.isPresent()) {
                galaxiesOptional.get().stream().forEach(galaxyKey -> {
                    Galaxy.Serializable galaxy = this.galaxies.get(galaxyKey.m_135782_().toString());
                    if (galaxy != null) {
                        galaxy.addPointOfOrigin((ResourceKey<PointOfOrigin>)pointOfOriginKey);
                    }
                });
            }
        });
    }

    public ResourceKey<PointOfOrigin> getRandomPointOfOriginFromDimension(ResourceKey<Level> dimension, long seed) {
        Optional<Galaxy.Serializable> galaxyOptional = this.getGalaxyFromDimension(dimension);
        if (galaxyOptional.isPresent()) {
            Galaxy.Serializable galaxy = galaxyOptional.get();
            return galaxy.getRandomPointOfOrigin(seed);
        }
        return PointOfOrigin.defaultPointOfOrigin();
    }

    private void registerSolarSystemsFromDataPacks(MinecraftServer server) {
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry solarSystemRegistry = registries.m_175515_(SolarSystem.REGISTRY_KEY);
        Set solarSystemSet = solarSystemRegistry.m_6579_();
        solarSystemSet.forEach(solarSystem -> this.addSolarSystemFromDataPack(server, (ResourceKey<SolarSystem>)((ResourceKey)solarSystem.getKey()), (SolarSystem)solarSystem.getValue()));
        StargateJourney.LOGGER.info("Datapack Solar Systems registered");
    }

    private void generateAndRegisterSolarSystems(MinecraftServer server) {
        Set levelSet = server.m_129784_();
        levelSet.forEach(dimension -> {
            if (!this.dimensions.containsKey(dimension)) {
                this.generateNewSolarSystem(server, (ResourceKey<Level>)dimension);
            }
        });
        StargateJourney.LOGGER.info("Solar Systems generated");
    }

    private void addSolarSystemFromDataPack(MinecraftServer server, ResourceKey<SolarSystem> solarSystemKey, SolarSystem solarSystem) {
        Address.Immutable extragalacticAddress;
        if (this.useDatapackAddresses(server)) {
            extragalacticAddress = new Address(solarSystem.getAddressArray()).immutable();
        } else {
            int prefix = solarSystem.getSymbolPrefix();
            long seed = this.generateRandomAddressSeed(server, solarSystemKey.m_135782_().toString());
            extragalacticAddress = this.generateExtragalacticAddress(prefix <= 0 ? 1 : prefix, seed);
        }
        SolarSystem.Serializable networkSolarSystem = new SolarSystem.Serializable(extragalacticAddress, solarSystemKey, solarSystem);
        if (this.saveSolarSystem(extragalacticAddress, networkSolarSystem) && solarSystem.getAddresses().isPresent()) {
            solarSystem.getAddresses().get().stream().forEach(galaxyAndAddress -> {
                ResourceKey galaxyKey = (ResourceKey)galaxyAndAddress.getFirst();
                Galaxy.Serializable galaxy = this.galaxies.get(galaxyKey.m_135782_().toString());
                if (galaxy != null) {
                    Address.Immutable address;
                    Pair randomizableAddress = (Pair)galaxyAndAddress.getSecond();
                    boolean isRandomizable = (Boolean)randomizableAddress.getSecond();
                    if (!this.useDatapackAddresses(server) && isRandomizable) {
                        long systemValue = this.generateRandomAddressSeed(server, solarSystemKey.m_135782_().toString());
                        address = this.generateAddress(galaxyKey.m_135782_().toString(), galaxy.getSize(), systemValue);
                    } else {
                        address = new Address(Address.integerListToArray((List)randomizableAddress.getFirst())).immutable();
                    }
                    galaxy.addSolarSystem(address, networkSolarSystem);
                    networkSolarSystem.addToGalaxy(galaxy, address);
                }
            });
        }
    }

    private void generateNewSolarSystem(MinecraftServer server, ResourceKey<Level> dimension) {
        String galaxyID;
        Galaxy.Serializable galaxy;
        ResourceKey<PointOfOrigin> pointOfOrigin;
        SolarSystem.Serializable solarSystem;
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry galaxyRegistry = registries.m_175515_(Galaxy.REGISTRY_KEY);
        Galaxy defaultGalaxy = (Galaxy)galaxyRegistry.m_7745_(MILKY_WAY);
        ResourceKey<Symbols> defaultSymbols = defaultGalaxy.getDefaultSymbols();
        String dimensionName = dimension.m_135782_().toString();
        long seed = this.generateRandomAddressSeed(server, dimensionName);
        String systemName = this.generateSolarSystemName(seed);
        int milkyWayPrefix = 1;
        Address.Immutable extragalacticAddress = this.generateExtragalacticAddress(milkyWayPrefix, seed);
        if (this.saveSolarSystem(extragalacticAddress, solarSystem = new SolarSystem.Serializable(systemName, extragalacticAddress, pointOfOrigin = (galaxy = this.galaxies.get(galaxyID = "sgjourney:milky_way")) != null ? galaxy.getRandomPointOfOrigin(seed) : PointOfOrigin.defaultPointOfOrigin(), defaultSymbols, milkyWayPrefix, List.of(dimension)))) {
            long systemValue = this.generateRandomAddressSeed(server, solarSystem.getName());
            Address.Immutable address = this.generateAddress(galaxyID, defaultGalaxy.getType().getSize(), systemValue);
            if (galaxy != null) {
                galaxy.addSolarSystem(address, solarSystem);
                solarSystem.addToGalaxy(galaxy, address);
            }
        }
    }

    private String generateSolarSystemName(long seed) {
        int maxRandom = NUMBERS_AND_LETTERS.length();
        Random random = new Random(seed);
        int prefixAValue = random.nextInt(0, maxRandom);
        int prefixBValue = random.nextInt(0, maxRandom);
        char prefixA = NUMBERS_AND_LETTERS.charAt(prefixAValue);
        char prefixB = NUMBERS_AND_LETTERS.charAt(prefixBValue);
        int suffixValue = random.nextInt(1, 10000);
        String systemName = "P" + prefixA + prefixB + "-" + suffixValue;
        return systemName;
    }

    private long generateRandomAddressSeed(MinecraftServer server, String name) {
        long seed = this.randomAddressFromSeed(server) ? server.m_129910_().m_246337_().m_245499_() : 0L;
        for (int i = 0; i < name.length(); ++i) {
            seed += (long)Character.valueOf(name.charAt(i)).charValue();
        }
        return seed;
    }

    private Address.Immutable generateExtragalacticAddress(int prefix, long seed) {
        Address.Immutable extragalacticAddress;
        int i = 0;
        while (this.solarSystems.containsKey(extragalacticAddress = new Address().randomAddress(prefix, 7, 36, seed += (long)i).immutable())) {
            ++i;
        }
        return extragalacticAddress;
    }

    private boolean saveSolarSystem(Address.Immutable extragalacticAddress, SolarSystem.Serializable solarSystem) {
        String solarSystemName = solarSystem.getName();
        if (this.solarSystems.containsKey(extragalacticAddress)) {
            StargateJourney.LOGGER.info("Failed to save Solar System " + solarSystemName + " as it is already saved in the Stargate Network");
            return false;
        }
        this.solarSystems.put(extragalacticAddress, solarSystem);
        solarSystem.getDimensions().forEach(dimension -> this.dimensions.put((ResourceKey<Level>)dimension, solarSystem));
        String pointOfOrigin = solarSystem.getPointOfOrigin().m_135782_().toString();
        String symbols = solarSystem.getSymbols().m_135782_().toString();
        StargateJourney.LOGGER.info("Saved Solar System: " + solarSystemName + "[PoO: " + pointOfOrigin + " Symbols: " + symbols + "]");
        return true;
    }

    private Address.Immutable generateAddress(String galaxyID, int galaxySize, long seed) {
        Address.Immutable address;
        int i = 0;
        while (true) {
            address = new Address().randomAddress(6, galaxySize, seed += (long)i).immutable();
            if (!this.galaxies.get(galaxyID).containsSolarSystem(address)) break;
            ++i;
        }
        return address;
    }

    public void addStargateToDimension(ResourceKey<Level> dimension, Stargate stargate) {
        Optional<SolarSystem.Serializable> solarSystem = this.getSolarSystemFromDimension(dimension);
        if (solarSystem.isPresent()) {
            solarSystem.get().addStargate(stargate);
            this.m_77762_();
        }
    }

    public void removeStargateFromDimension(ResourceKey<Level> dimension, Stargate stargate) {
        Optional<SolarSystem.Serializable> solarSystem = this.getSolarSystemFromDimension(dimension);
        if (solarSystem.isPresent()) {
            solarSystem.get().removeStargate(stargate);
            this.m_77762_();
        }
    }

    public void printDimensions() {
        System.out.println("[Dimensions - Solar Systems]");
        this.dimensions.entrySet().stream().forEach(dimensionEntry -> System.out.println("- |" + ((ResourceKey)dimensionEntry.getKey()).m_135782_().toString() + "| = |" + ((SolarSystem.Serializable)dimensionEntry.getValue()).getName() + "|"));
    }

    public void printSolarSystems() {
        System.out.println("[Solar Systems]");
        this.solarSystems.entrySet().stream().forEach(solarSystemEntry -> {
            SolarSystem.Serializable solarSystem = (SolarSystem.Serializable)solarSystemEntry.getValue();
            System.out.println("- [Generated: " + solarSystem.isGenerated() + "] " + ((Address.Immutable)solarSystemEntry.getKey()).toString() + " " + solarSystem.getName());
            solarSystem.getStargates().stream().forEach(stargate -> System.out.println("--- " + stargate.toString()));
        });
    }

    public void printGalaxies() {
        System.out.println("[Galaxies]");
        this.galaxies.entrySet().stream().forEach(galaxyEntry -> {
            Galaxy.Serializable galaxy = (Galaxy.Serializable)galaxyEntry.getValue();
            System.out.println("- " + ((String)galaxyEntry.getKey()).toString());
            galaxy.printSolarSystems();
        });
    }

    public Optional<SolarSystem.Serializable> getSolarSystemFromDimension(ResourceKey<Level> dimension) {
        if (!this.dimensions.containsKey(dimension)) {
            return Optional.empty();
        }
        return Optional.of(this.dimensions.get(dimension));
    }

    public Optional<SolarSystem.Serializable> getSolarSystemFromExtragalacticAddress(Address.Immutable extragalacticAddress) {
        if (!this.solarSystems.containsKey(extragalacticAddress)) {
            return Optional.empty();
        }
        return Optional.of(this.solarSystems.get(extragalacticAddress));
    }

    public List<ResourceKey<Level>> getDimensionsWithGeneratedSolarSystems() {
        ArrayList<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
        this.dimensions.entrySet().forEach(dimensionEntry -> {
            if (((SolarSystem.Serializable)dimensionEntry.getValue()).isGenerated()) {
                dimensions.add((ResourceKey)dimensionEntry.getKey());
            }
        });
        return dimensions;
    }

    public Optional<List<ResourceKey<Level>>> getDimensionsFromSolarSystem(Address.Immutable extragalacticAddress) {
        Optional<SolarSystem.Serializable> solarSystemOptional = this.getSolarSystemFromExtragalacticAddress(extragalacticAddress);
        if (solarSystemOptional.isPresent()) {
            return Optional.of(solarSystemOptional.get().getDimensions());
        }
        return Optional.empty();
    }

    public Optional<SolarSystem.Serializable> getSolarSystemInGalaxy(String galaxyID, Address.Immutable address) {
        if (!this.galaxies.containsKey(galaxyID)) {
            return Optional.empty();
        }
        return this.galaxies.get(galaxyID).getSolarSystem(address);
    }

    public Optional<SolarSystem.Serializable> getSolarSystemFromAddress(ResourceKey<Level> dimension, Address.Immutable address) {
        Optional<SolarSystem.Serializable> solarSystemOptional = this.getSolarSystemFromDimension(dimension);
        if (solarSystemOptional.isPresent()) {
            return solarSystemOptional.get().getSolarSystemFromAddress(address);
        }
        return Optional.empty();
    }

    public Optional<HashMap<Galaxy.Serializable, Address.Immutable>> getGalaxiesFromDimension(ResourceKey<Level> dimension) {
        Optional<SolarSystem.Serializable> solarSystemOptional = this.getSolarSystemFromDimension(dimension);
        if (solarSystemOptional.isPresent()) {
            return Optional.of(solarSystemOptional.get().getGalacticAddresses());
        }
        return Optional.empty();
    }

    public Optional<Galaxy.Serializable> getGalaxyFromDimension(ResourceKey<Level> dimension) {
        HashMap<Galaxy.Serializable, Address.Immutable> galaxies;
        Optional<HashMap<Galaxy.Serializable, Address.Immutable>> galaxiesOptional = this.getGalaxiesFromDimension(dimension);
        if (galaxiesOptional.isPresent() && !(galaxies = galaxiesOptional.get()).isEmpty()) {
            return Optional.of(galaxies.entrySet().iterator().next().getKey());
        }
        return Optional.empty();
    }

    public Optional<Address.Immutable> getAddressInGalaxyFromSolarSystem(String galaxyID, SolarSystem.Serializable solarSystem) {
        if (this.galaxies.containsKey(galaxyID)) {
            Galaxy.Serializable galaxy = this.galaxies.get(galaxyID);
            return solarSystem.getAddressFromGalaxy(galaxy);
        }
        return Optional.empty();
    }

    public Optional<Address.Immutable> getAddressInGalaxyFromDimension(String galaxyID, ResourceKey<Level> dimension) {
        Optional<SolarSystem.Serializable> solarSystemOptional = this.getSolarSystemFromDimension(dimension);
        if (solarSystemOptional.isPresent()) {
            return this.getAddressInGalaxyFromSolarSystem(galaxyID, solarSystemOptional.get());
        }
        return Optional.empty();
    }

    public Optional<Address.Immutable> getExtragalacticAddressFromDimension(ResourceKey<Level> dimension) {
        Optional<SolarSystem.Serializable> solarSystemOptional = this.getSolarSystemFromDimension(dimension);
        if (solarSystemOptional.isPresent()) {
            SolarSystem.Serializable solarSystem = solarSystemOptional.get();
            return Optional.of(solarSystem.getExtragalacticAddress());
        }
        return Optional.empty();
    }

    public ResourceKey<PointOfOrigin> getPointOfOrigin(ResourceKey<Level> dimension) {
        Optional<SolarSystem.Serializable> solarSystemOptional = this.getSolarSystemFromDimension(dimension);
        if (solarSystemOptional.isPresent()) {
            SolarSystem.Serializable solarSystem = solarSystemOptional.get();
            return solarSystem.getPointOfOrigin();
        }
        return PointOfOrigin.defaultPointOfOrigin();
    }

    public ResourceKey<Symbols> getSymbols(ResourceKey<Level> dimension) {
        Optional<SolarSystem.Serializable> solarSystemOptional = this.getSolarSystemFromDimension(dimension);
        if (solarSystemOptional.isPresent()) {
            SolarSystem.Serializable solarSystem = solarSystemOptional.get();
            return solarSystem.getSymbols();
        }
        return Symbols.defaultSymbols();
    }

    private CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(SOLAR_SYSTEMS, (Tag)this.serializeSolarSystems());
        tag.m_128365_(DIMENSIONS, (Tag)this.serializeDimensions());
        tag.m_128365_(GALAXIES, (Tag)this.serializeGalaxies());
        return tag;
    }

    private CompoundTag serializeDimensions() {
        CompoundTag dimensionsTag = new CompoundTag();
        this.dimensions.forEach((dimension, solarSystem) -> dimensionsTag.m_128385_(dimension.m_135782_().toString(), solarSystem.getExtragalacticAddress().toArray()));
        return dimensionsTag;
    }

    private CompoundTag serializeSolarSystems() {
        CompoundTag solarSystemsTag = new CompoundTag();
        this.solarSystems.forEach((extragalacticAddress, solarSystem) -> solarSystemsTag.m_128365_(extragalacticAddress.toString(), (Tag)solarSystem.serialize()));
        return solarSystemsTag;
    }

    private CompoundTag serializeGalaxies() {
        CompoundTag galaxiesTag = new CompoundTag();
        this.galaxies.forEach((galaxyID, galaxy) -> galaxiesTag.m_128365_(galaxyID, (Tag)galaxy.serialize()));
        return galaxiesTag;
    }

    private void deserialize(MinecraftServer server, CompoundTag tag) {
        this.deserializeSolarSystems(tag.m_128469_(SOLAR_SYSTEMS));
        this.deserializeDimensions(tag.m_128469_(DIMENSIONS));
        this.deserializeGalaxies(server, tag.m_128469_(GALAXIES));
    }

    private void deserializeSolarSystems(CompoundTag tag) {
        RegistryAccess.Frozen registries = this.server.m_206579_();
        Registry solarSystemRegistry = registries.m_175515_(SolarSystem.REGISTRY_KEY);
        tag.m_128431_().forEach(solarSystemString -> {
            SolarSystem.Serializable solarSystem = SolarSystem.Serializable.deserialize(this.server, (Registry<SolarSystem>)solarSystemRegistry, tag.m_128469_(solarSystemString));
            this.solarSystems.put(solarSystem.getExtragalacticAddress(), solarSystem);
        });
    }

    private void deserializeDimensions(CompoundTag tag) {
        tag.m_128431_().forEach(dimensionString -> {
            Address.Immutable extragalacticAddress = new Address(tag.m_128465_(dimensionString)).immutable();
            if (this.solarSystems.containsKey(extragalacticAddress)) {
                SolarSystem.Serializable solarSystem = this.solarSystems.get(extragalacticAddress);
                this.dimensions.put(Conversion.stringToDimension(dimensionString), solarSystem);
            }
        });
    }

    private void deserializeGalaxies(MinecraftServer server, CompoundTag tag) {
        RegistryAccess.Frozen registries = server.m_206579_();
        Registry galaxyRegistry = registries.m_175515_(Galaxy.REGISTRY_KEY);
        tag.m_128431_().forEach(galaxyString -> {
            ResourceKey<Galaxy> galaxyKey = Conversion.stringToGalaxyKey(galaxyString);
            Galaxy.Serializable galaxy = Galaxy.Serializable.deserialize(server, this.solarSystems, (Registry<Galaxy>)galaxyRegistry, galaxyKey, tag.m_128469_(galaxyString));
            this.galaxies.put(galaxy.getKey().m_135782_().toString(), galaxy);
        });
    }

    public Universe(MinecraftServer server) {
        this.server = server;
    }

    public static Universe create(MinecraftServer server) {
        return new Universe(server);
    }

    public static Universe load(MinecraftServer server, CompoundTag tag) {
        Universe data = Universe.create(server);
        data.server = server;
        data.deserialize(server, tag);
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.serialize();
        return tag;
    }

    @Nonnull
    public static Universe get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return Universe.get(level.m_7654_());
    }

    @Nonnull
    public static Universe get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (Universe)storage.m_164861_(tag -> Universe.load(server, tag), () -> Universe.create(server), FILE_NAME);
    }
}

