/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.Transporter;

public class BlockEntityList
extends SavedData {
    private static final String FILE_NAME = "sgjourney-block_entities";
    private static final String INCORRECT_FILE_NAME = "sgjourney-block_enties";
    public static final String STARGATES = "Stargates";
    public static final String TRANSPORT_RINGS = "TransportRings";
    public static final String TRANSPORTERS = "Transporters";
    private MinecraftServer server;
    protected HashMap<Address.Immutable, Stargate> stargateMap = new HashMap();
    protected HashMap<UUID, Transporter> transporterMap = new HashMap();

    public Optional<Stargate> addStargate(AbstractStargateEntity stargate) {
        Address.Immutable address = stargate.get9ChevronAddress().immutable();
        if (address.getLength() != 8) {
            return Optional.empty();
        }
        if (this.stargateMap.containsKey(address)) {
            return Optional.of(this.stargateMap.get(address));
        }
        if (stargate.m_58904_() == null) {
            return Optional.empty();
        }
        if (stargate.m_58899_() == null) {
            return Optional.empty();
        }
        Stargate savedStargate = new Stargate(stargate);
        this.stargateMap.put(address, savedStargate);
        this.m_77762_();
        StargateJourney.LOGGER.info("Added Stargate " + address.toString() + " to BlockEntityList");
        return Optional.of(savedStargate);
    }

    public Optional<Transporter> addTransporter(AbstractTransporterEntity transporterEntity) {
        UUID id;
        if (transporterEntity.getID() == null) {
            transporterEntity.setID(transporterEntity.generateID());
        }
        if (this.transporterMap.containsKey(id = transporterEntity.getID())) {
            return Optional.of(this.transporterMap.get(id));
        }
        if (transporterEntity.m_58904_() == null) {
            return Optional.empty();
        }
        if (transporterEntity.m_58899_() == null) {
            return Optional.empty();
        }
        Transporter transporter = new Transporter(transporterEntity);
        this.transporterMap.put(id, transporter);
        this.m_77762_();
        StargateJourney.LOGGER.info("Added Transporter " + id + " to BlockEntityList");
        return Optional.of(transporter);
    }

    public void removeStargate(Address.Immutable id) {
        if (!this.stargateMap.containsKey(id)) {
            StargateJourney.LOGGER.error(id + " not found in BlockEntityList");
            return;
        }
        this.stargateMap.remove(id);
        StargateJourney.LOGGER.info("Removed Stargate " + id + " from BlockEntityList");
        this.m_77762_();
    }

    public void removeTransporter(UUID id) {
        if (!this.transporterMap.containsKey(id)) {
            StargateJourney.LOGGER.error(id + " not found in BlockEntityList");
            return;
        }
        this.transporterMap.remove(id);
        StargateJourney.LOGGER.info("Removed Transporter " + id + " from BlockEntityList");
        this.m_77762_();
    }

    public void printStargates() {
        System.out.println("[Stargates]");
        this.stargateMap.entrySet().stream().forEach(stargateEntry -> System.out.println("- " + ((Stargate)stargateEntry.getValue()).toString()));
    }

    public HashMap<Address.Immutable, Stargate> getStargates() {
        return (HashMap)this.stargateMap.clone();
    }

    public Optional<Stargate> getStargate(Address.Immutable address) {
        Stargate stargate;
        if (address.getLength() == 8 && (stargate = this.stargateMap.get(address)) != null) {
            return Optional.of(stargate);
        }
        return Optional.empty();
    }

    public Optional<Stargate> getRandomStargate(long seed) {
        int size = this.stargateMap.size();
        if (size < 1) {
            return Optional.empty();
        }
        Random random = new Random(seed);
        int randomValue = random.nextInt(0, size);
        Stargate randomStargate = (Stargate)this.stargateMap.entrySet().stream().toArray()[randomValue];
        return Optional.of(randomStargate);
    }

    public HashMap<UUID, Transporter> getTransporters() {
        return (HashMap)this.transporterMap.clone();
    }

    public Optional<Transporter> getTransporter(UUID id) {
        Transporter transporter = this.transporterMap.get(id);
        if (transporter != null) {
            return Optional.of(transporter);
        }
        return Optional.empty();
    }

    public void printTransporters() {
        System.out.println("[Transporters]");
        this.transporterMap.entrySet().stream().forEach(transporterEntry -> System.out.println("- " + transporterEntry.getKey() + " " + ((Transporter)transporterEntry.getValue()).toString()));
    }

    public CompoundTag serialize() {
        CompoundTag blockEntityList = new CompoundTag();
        CompoundTag stargates = this.serializeStargates();
        CompoundTag transportRings = this.serializeTransporters();
        blockEntityList.m_128365_(STARGATES, (Tag)stargates);
        blockEntityList.m_128365_(TRANSPORTERS, (Tag)transportRings);
        return blockEntityList;
    }

    private CompoundTag serializeStargates() {
        CompoundTag stargates = new CompoundTag();
        this.stargateMap.forEach((stargateID, stargate) -> {
            if (stargate != null) {
                stargates.m_128365_(stargateID.toString(), (Tag)stargate.serialize());
            } else {
                StargateJourney.LOGGER.info("Cannot serialize Stargate " + stargateID + " because it's null");
            }
        });
        return stargates;
    }

    private CompoundTag serializeTransporters() {
        CompoundTag transportersTag = new CompoundTag();
        this.transporterMap.forEach((ringsID, transporter) -> transportersTag.m_128365_(ringsID.toString(), (Tag)transporter.serialize()));
        return transportersTag;
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag blockEntityList = tag.m_6426_();
        this.deserializeStargates(blockEntityList);
        this.deserializeTransporters(blockEntityList);
    }

    private void deserializeStargates(CompoundTag blockEntityList) {
        StargateJourney.LOGGER.info("Deserializing Stargates");
        CompoundTag stargates = blockEntityList.m_128469_(STARGATES);
        stargates.m_128431_().stream().forEach(stargateAddress -> {
            Address.Immutable address = new Address((String)stargateAddress).immutable();
            Stargate stargate = Stargate.deserialize(this.server, address, stargates.m_128469_(stargateAddress));
            if (stargate != null) {
                this.stargateMap.put(address, stargate);
            }
        });
        StargateJourney.LOGGER.info("Finished deserializing Stargates");
    }

    private void deserializeTransporters(CompoundTag blockEntityList) {
        StargateJourney.LOGGER.info("Deserializing Transporters");
        if (blockEntityList.m_128441_(TRANSPORT_RINGS)) {
            CompoundTag transportRingsTag = blockEntityList.m_128469_(TRANSPORT_RINGS);
            transportRingsTag.m_128431_().stream().forEach(transportRings -> {
                Transporter transporter = Transporter.deserialize(this.server, transportRings, transportRingsTag.m_128469_(transportRings));
                if (!this.transporterMap.containsKey(transporter.getID())) {
                    this.transporterMap.put(transporter.getID(), transporter);
                }
            });
        }
        CompoundTag transportersTag = blockEntityList.m_128469_(TRANSPORTERS);
        transportersTag.m_128431_().stream().forEach(transporterString -> {
            Transporter transporter = Transporter.deserialize(this.server, transporterString, transportersTag.m_128469_(transporterString));
            if (!this.transporterMap.containsKey(transporter.getID())) {
                this.transporterMap.put(transporter.getID(), transporter);
            }
        });
        StargateJourney.LOGGER.info("Finished deserializing Transporters");
    }

    public BlockEntityList(MinecraftServer server) {
        this.server = server;
    }

    public static BlockEntityList create(MinecraftServer server) {
        return new BlockEntityList(server);
    }

    public static BlockEntityList load(MinecraftServer server, CompoundTag tag) {
        BlockEntityList data = BlockEntityList.create(server);
        data.server = server;
        data.deserialize(tag);
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.serialize();
        return tag;
    }

    @Nonnull
    public static BlockEntityList get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return BlockEntityList.get(level.m_7654_());
    }

    @Nonnull
    public static BlockEntityList get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (BlockEntityList)storage.m_164861_(tag -> BlockEntityList.load(server, tag), () -> BlockEntityList.create(server), INCORRECT_FILE_NAME);
    }
}

