/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundCrystallizerUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCrystallizerEntity
extends EnergyBlockEntity {
    private static final String PROGRESS = "Progress";
    public static final int LIQUID_NAQUADAH_CAPACITY = 4000;
    public static final int MAX_PROGRESS = 200;
    protected final ItemStackHandler itemHandler = this.createHandler();
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    protected LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();
    public int progress = 0;
    private final FluidTank fluidTank = new FluidTank(4000){

        protected void onContentsChanged() {
            AbstractCrystallizerEntity.this.m_6596_();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid() == AbstractCrystallizerEntity.this.getDesiredFluid();
        }
    };

    public AbstractCrystallizerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.lazyFluidHandler = LazyOptional.of(() -> this.fluidTank);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidHandler.invalidate();
        this.handler.invalidate();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("Inventory"));
        this.fluidTank.readFromNBT(nbt);
        this.progress = nbt.m_128451_(PROGRESS);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        nbt.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        nbt = this.fluidTank.writeToNBT(nbt);
        nbt.m_128405_(PROGRESS, this.progress);
        super.m_183515_(nbt);
    }

    public abstract Fluid getDesiredFluid();

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction side) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidTank.setFluid(fluidStack);
    }

    public FluidStack getFluid() {
        return this.fluidTank.getFluid();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                AbstractCrystallizerEntity.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return switch (slot) {
                    case 4 -> 1;
                    default -> 64;
                };
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return switch (slot) {
                    case 3 -> false;
                    case 4 -> stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
                    default -> true;
                };
            }

            @NotNull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public boolean hasFluidItem() {
        return this.itemHandler.getStackInSlot(4).m_41613_() > 0;
    }

    public void fillFluidTank(FluidStack stack, ItemStack container) {
        this.fluidTank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        this.itemHandler.extractItem(4, 1, false);
        this.itemHandler.insertItem(4, container, false);
    }

    public void drainFluidFromItem() {
        this.itemHandler.getStackInSlot(4).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            int drainAmount = Math.min(this.fluidTank.getSpace(), 1000);
            FluidStack stack = handler.getFluidInTank(0);
            if (this.fluidTank.isFluidValid(stack)) {
                stack = handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                this.fillFluidTank(stack, handler.getContainer());
            }
        });
    }

    @Override
    protected long capacity() {
        return 0L;
    }

    @Override
    protected long maxReceive() {
        return 0L;
    }

    @Override
    protected long maxExtract() {
        return 0L;
    }

    protected static boolean hasSpaceInOutputSlot(SimpleContainer inventory, ItemStack stack) {
        if (inventory.m_8020_(3).m_41741_() <= inventory.m_8020_(3).m_41613_()) {
            return false;
        }
        return inventory.m_8020_(3).m_41720_() == stack.m_41720_() || inventory.m_8020_(3).m_41619_();
    }

    protected abstract boolean hasIngredients();

    protected abstract void crystallize();

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractCrystallizerEntity crystallizer) {
        if (level.m_5776_()) {
            return;
        }
        if (crystallizer.hasFluidItem()) {
            crystallizer.drainFluidFromItem();
        }
        if (crystallizer.hasIngredients() && crystallizer.fluidTank.getFluidAmount() > 0) {
            ++crystallizer.progress;
            crystallizer.fluidTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
            AbstractCrystallizerEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (crystallizer.progress >= 200) {
                crystallizer.crystallize();
            }
        } else {
            crystallizer.progress = 0;
            AbstractCrystallizerEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(crystallizer.f_58858_)), (Object)new ClientboundCrystallizerUpdatePacket(crystallizer.f_58858_, crystallizer.getFluid(), crystallizer.progress));
    }
}

