/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.sound;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariants;
import net.povstalec.sgjourney.client.sound.StargateSoundWrapper;
import net.povstalec.sgjourney.client.sound.sounds.GenericStargateSound;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

public class SoundAccess {
    public static final String EMPTY = StargateJourney.EMPTY;
    protected static Minecraft minecraft = Minecraft.m_91087_();

    public static void playWormholeOpenSound(BlockPos pos, boolean incoming) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getWormholeOpenSound(stargate, incoming), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playWormholeIdleSound(BlockPos pos, boolean incoming) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            if (stargate.wormholeIdleSound == null || !stargate.wormholeIdleSound.hasSound()) {
                stargate.wormholeIdleSound = new StargateSoundWrapper.WormholeIdle(stargate, incoming);
            }
            stargate.playWormholeIdleSound();
        }
    }

    public static void playWormholeCloseSound(BlockPos pos, boolean incoming) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getWormholeCloseSound(stargate, incoming), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playIrisThudSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, (SoundEvent)SoundInit.IRIS_THUD.get(), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void playChevronSound(BlockPos pos, short chevron, boolean incoming, boolean open, boolean encode) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (!(blockEntity instanceof AbstractStargateEntity)) return;
        AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
        if (stargate instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity milkyWayStargate = (MilkyWayStargateEntity)stargate;
            if (open || encode) {
                if (open) {
                    GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronOpenSound(milkyWayStargate, chevron), 0.5f);
                    minecraft.m_91106_().m_120367_((SoundInstance)sound);
                    return;
                }
                if (!encode) return;
                GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronEncodeSound(milkyWayStargate, chevron), 0.5f);
                minecraft.m_91106_().m_120367_((SoundInstance)sound);
                return;
            }
        }
        if (incoming) {
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronIncomingSound(stargate, chevron), 0.5f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
            return;
        }
        GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronEngageSound(stargate, chevron), 0.5f);
        minecraft.m_91106_().m_120367_((SoundInstance)sound);
    }

    public static void playFailSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getFailSound(stargate, Stargate.Feedback.UNKNOWN_ERROR), 0.5f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playRotationSound(BlockPos pos, boolean stop) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            if (stargate.spinSound == null) {
                if (stargate instanceof UniverseStargateEntity) {
                    UniverseStargateEntity universeStargate = (UniverseStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.UniverseRingRotation(universeStargate);
                } else if (stargate instanceof MilkyWayStargateEntity) {
                    MilkyWayStargateEntity milkyWayStargate = (MilkyWayStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.MilkyWayRingRotation(milkyWayStargate);
                } else if (stargate instanceof PegasusStargateEntity) {
                    PegasusStargateEntity pegasusStargate = (PegasusStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.PegasusRingRotation(pegasusStargate);
                }
            }
            if (stop) {
                stargate.stopRotationSound();
            } else {
                stargate.playRotationSound();
            }
        }
    }

    public static void playUniverseStartSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof UniverseStargateEntity) {
            UniverseStargateEntity stargate = (UniverseStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getRotationStartupSound(stargate), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playMilkyWayBuildupSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)blockEntity;
            if (stargate.buildupSound == null || !stargate.buildupSound.hasSound()) {
                stargate.buildupSound = new StargateSoundWrapper.MilkyWayRingBuildup(stargate);
            }
            stargate.playBuildupSound();
        }
    }

    public static void playMilkyWayStopSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getRotationStopSound(stargate), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    private static SoundEvent getChevronEngageSound(AbstractStargateEntity stargate, short chevron) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).chevronEngagedSounds().getSound(chevron));
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).chevronEngagedSounds().getSound(chevron));
    }

    private static SoundEvent getChevronOpenSound(MilkyWayStargateEntity stargate, short chevron) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargateVariant.get().clientVariant()).chevronOpenSounds().getSound(chevron));
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargate.defaultVariant()).chevronOpenSounds().getSound(chevron));
    }

    private static SoundEvent getChevronEncodeSound(MilkyWayStargateEntity stargate, short chevron) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargateVariant.get().clientVariant()).chevronEncodeSounds().getSound(chevron));
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargate.defaultVariant()).chevronEncodeSounds().getSound(chevron));
    }

    private static SoundEvent getChevronIncomingSound(AbstractStargateEntity stargate, short chevron) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).chevronIncomingSounds().getSound(chevron));
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).chevronIncomingSounds().getSound(chevron));
    }

    public static SoundEvent getRotationStartupSound(AbstractStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargateVariant.get().clientVariant(), stargate).rotationSounds().rotationStartupSound());
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargate.defaultVariant(), stargate).rotationSounds().rotationStartupSound());
    }

    public static SoundEvent getRotationSound(AbstractStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargateVariant.get().clientVariant(), stargate).rotationSounds().rotationSound());
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getRotatingStargateVariant(stargate.defaultVariant(), stargate).rotationSounds().rotationSound());
    }

    public static SoundEvent getRotationStopSound(MilkyWayStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargateVariant.get().clientVariant()).rotationSounds().rotationStopSound());
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getMilkyWayStargateVariant(stargate.defaultVariant()).rotationSounds().rotationStopSound());
    }

    private static SoundEvent getFailSound(AbstractStargateEntity stargate, Stargate.Feedback stargateFeedback) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).failSounds().getSound(stargateFeedback));
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).failSounds().getSound(stargateFeedback));
    }

    private static SoundEvent getWormholeOpenSound(AbstractStargateEntity stargate, boolean incoming) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).wormholeSounds().getOpenSound(incoming));
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).wormholeSounds().getOpenSound(incoming));
    }

    public static SoundEvent getWormholeIdleSound(AbstractStargateEntity stargate, boolean incoming) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).wormholeSounds().getIdleSound(incoming));
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).wormholeSounds().getIdleSound(incoming));
    }

    private static SoundEvent getWormholeCloseSound(AbstractStargateEntity stargate, boolean incoming) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargateVariant.get().clientVariant(), stargate).wormholeSounds().getCloseSound(incoming));
        }
        return SoundEvent.m_262824_((ResourceLocation)ClientStargateVariants.getClientStargateVariant(stargate.defaultVariant(), stargate).wormholeSounds().getCloseSound(incoming));
    }
}

