/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.povstalec.sgjourney.client.models.TollanStargateModel;
import net.povstalec.sgjourney.client.render.block_entity.AbstractStargateRenderer;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariants;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.TollanStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.TollanStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.TollanStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

@OnlyIn(value=Dist.CLIENT)
public class TollanStargateRenderer
extends AbstractStargateRenderer<TollanStargateEntity, TollanStargateVariant> {
    protected final TollanStargateModel stargateModel = new TollanStargateModel();

    public TollanStargateRenderer(BlockEntityRendererProvider.Context context) {
        super(context, 0.125f, true, 38.0f);
    }

    @Override
    protected TollanStargateVariant getClientVariant(TollanStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            if (stargateVariant.get().isFound()) {
                return ClientStargateVariants.getTollanStargateVariant(stargateVariant.get().clientVariant());
            }
            if (!stargateVariant.get().isMissing()) {
                stargateVariant.get().handleLocation(ClientStargateVariants.hasTollanStargateVariant(stargateVariant.get().clientVariant()));
            }
        }
        return ClientStargateVariants.getTollanStargateVariant(stargate.defaultVariant());
    }

    public void render(TollanStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        TollanStargateVariant stargateVariant = this.getClientVariant(stargate);
        BlockState blockstate = stargate.m_58900_();
        Direction facing = (Direction)blockstate.m_61143_((Property)TollanStargateBlock.FACING);
        Vec3 center = stargate.getRelativeCenter();
        Orientation orientation = (Orientation)((Object)blockstate.m_61143_((Property)AbstractStargateBaseBlock.ORIENTATION));
        this.renderCover(stargate, stack, source, combinedLight, combinedOverlay);
        stack.m_85836_();
        double shiftBase = (double)orientation.getIndex() * 0.5;
        double shiftX = center.m_7096_();
        double shiftY = center.m_7098_();
        double shiftZ = center.m_7094_();
        if (orientation != Orientation.REGULAR) {
            if (facing.m_122434_() == Direction.Axis.X) {
                shiftX += (double)facing.m_122421_().m_122540_() * shiftBase;
            } else {
                shiftZ += (double)facing.m_122421_().m_122540_() * shiftBase;
            }
        }
        stack.m_85837_(shiftX, shiftY, shiftZ);
        stack.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122435_()));
        if (orientation == Orientation.UPWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }
        this.stargateModel.renderStargate(stargate, stargateVariant, partialTick, stack, source, combinedLight, combinedOverlay);
        this.irisModel.renderIris(stargate, stack, source, combinedLight, combinedOverlay, stargate.getIrisProgress(partialTick));
        this.renderWormhole(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
        stack.m_85849_();
    }
}

