/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.playeranims;

import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.modifier.AbstractCameraModifier;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CustomModifierLayer<T extends IAnimation>
extends ModifierLayer
implements IAnimation {
    public static final Vec3f voidVector = new Vec3f(0.0f, -1.0E7f, 0.0f);
    public List<AbstractCameraModifier> cameraModifiers = new ArrayList<AbstractCameraModifier>();
    public int modifierCount = 0;
    public boolean hasModifier = false;
    public boolean cameraAnimEnabled;
    public final ResourceLocation ID;
    public PlayerAnimationData data;
    public ResourceLocation currentAnim;
    public KeyframeAnimationPlayer animPlayer;
    public AbstractClientPlayer player;
    private float speed = 1.0f;

    public void setAnimationData(PlayerAnimationData data) {
        this.data = data;
    }

    public void setAnimPlayer(KeyframeAnimationPlayer animPlayer) {
        this.animPlayer = animPlayer;
    }

    public void setCurrentAnimationLocation(ResourceLocation animation) {
        this.currentAnim = animation;
    }

    public CustomModifierLayer(@Nullable T animation, AbstractClientPlayer player, ResourceLocation ID, AbstractModifier ... modifiers) {
        this.player = player;
        this.ID = ID;
    }

    public void tick() {
        super.tick();
    }

    public void addModifier(@NotNull AbstractModifier modifier) {
        this.addModifier(modifier, this.modifierCount);
        ++this.modifierCount;
        this.hasModifier = true;
        if (modifier instanceof AbstractCameraModifier) {
            this.cameraAnimEnabled = true;
            this.cameraModifiers.add((AbstractCameraModifier)modifier);
        }
        if (modifier instanceof SpeedModifier) {
            this.speed *= ((SpeedModifier)modifier).speed;
        }
    }

    public void removeAllModifiers() {
        for (int i = this.modifierCount - 1; i >= 0; --i) {
            this.removeModifier(i);
        }
        this.modifierCount = 0;
        this.cameraAnimEnabled = false;
        this.hasModifier = false;
        this.speed = 1.0f;
        this.cameraModifiers = new ArrayList<AbstractCameraModifier>();
    }

    public void replaceAnimationWithFade(AbstractFadeModifier fadeModifier, KeyframeAnimationPlayer newAnimation) {
        this.setAnimPlayer(newAnimation);
        this.replaceAnimationWithFade(fadeModifier, (IAnimation)newAnimation, true);
    }

    public void replaceAnimation(KeyframeAnimationPlayer newAnimation) {
        this.setAnimPlayer(newAnimation);
        this.setAnimation((IAnimation)newAnimation);
        this.linkModifiers();
    }

    @NotNull
    public Vec3f get3DTransform(@NotNull String modelName, @NotNull TransformType type, float tickDelta, @NotNull Vec3f value0) {
        Vec3f transform = super.get3DTransform(modelName, type, tickDelta, value0);
        if (type == TransformType.POSITION && (modelName.equals("leftItem") && !this.data.parts().leftItem.isVisible || modelName.equals("rightItem") && !this.data.parts().rightItem.isVisible)) {
            transform = transform.add(voidVector);
        }
        return transform;
    }

    public float getSpeed() {
        return this.speed;
    }

    public CustomModifierLayer(AbstractClientPlayer player, ResourceLocation ID) {
        this(null, player, ID, new AbstractModifier[0]);
    }
}

