/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world.ore;

import igentuman.nc.content.materials.Ores;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.world.ore.DimensionBiomeFilter;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import org.jetbrains.annotations.NotNull;

public class OreGenerator {
    public static List<PlacementModifier> orePlacement(PlacementModifier modifier, PlacementModifier modifier1) {
        return List.of(modifier, InSquarePlacement.m_191715_(), modifier1, BiomeFilter.m_191561_());
    }

    public static List<PlacementModifier> commonOrePlacement(int pCount, PlacementModifier pHeightRange) {
        return OreGenerator.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)pCount), pHeightRange);
    }

    public static List<PlacementModifier> rareOrePlacement(int pChance, PlacementModifier pHeightRange) {
        return OreGenerator.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)pChance), pHeightRange);
    }

    @NotNull
    public static PlacedFeature createOregen(String ore) {
        String materialName = ore.replaceAll("_deepslate|_nether|_end", "");
        TagMatchTest test = new TagMatchTest(BlockTags.f_144266_);
        if (ore.contains("deepslate")) {
            test = new TagMatchTest(BlockTags.f_144267_);
        } else if (ore.contains("nether")) {
            test = new TagMatchTest(BlockTags.f_215835_);
        }
        OreConfiguration config = new OreConfiguration((RuleTest)test, ((Block)NCBlocks.ORE_BLOCKS.get(ore).get()).m_49966_(), Ores.all().get((Object)materialName).config().veinSize);
        return OreGenerator.createPlacedFeature((ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>>)new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)config), CountPlacement.m_191628_((int)Ores.all().get((Object)materialName).config().veinAmount), InSquarePlacement.m_191715_(), new DimensionBiomeFilter(key -> Ores.all().get((Object)materialName).config().dimensions.contains(key)), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)Ores.all().get((Object)materialName).config().height[0]), (VerticalAnchor)VerticalAnchor.m_158922_((int)Ores.all().get((Object)materialName).config().height[1])));
    }

    private static PlacedFeature createPlacedFeature(ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>> oreConfigurationFeatureConfiguredFeature, CountPlacement of, InSquarePlacement spread, DimensionBiomeFilter dimensionBiomeFilter, HeightRangePlacement uniform) {
        return new PlacedFeature(Holder.m_205709_(oreConfigurationFeatureConfiguredFeature), List.of(of, spread, dimensionBiomeFilter, uniform));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("nuclearcraft", name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

